/*
 * Decompiled with CFR 0.152.
 */
package arq.examples.riot;

import java.io.OutputStream;
import java.io.Writer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.LangBuilder;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFWriterRegistry;
import org.apache.jena.riot.WriterGraphRIOT;
import org.apache.jena.riot.WriterGraphRIOTFactory;
import org.apache.jena.riot.adapters.RDFWriterRIOT;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.writer.WriterGraphRIOTBase;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.util.Context;

public class ExRIOT7_AddNewWriter {
    public static void main(String[] args) {
        System.out.println("## Example of a registering a new language with RIOT for writing");
        System.out.println();
        Lang lang = LangBuilder.create((String)"SSE", (String)"text/x-sse").addFileExtensions(new String[]{"rsse"}).build();
        RDFLanguages.register((Lang)lang);
        RDFFormat format = new RDFFormat(lang);
        RDFWriterRegistry.register((Lang)lang, (RDFFormat)format);
        RDFWriterRegistry.register((RDFFormat)format, (WriterGraphRIOTFactory)new SSEWriterFactory());
        Model model = RDFDataMgr.loadModel((String)"/home/afs/tmp/D.ttl");
        System.out.println("## Write by format");
        RDFDataMgr.write((OutputStream)System.out, (Model)model, (RDFFormat)format);
        System.out.println();
        System.out.println("## Write by language");
        RDFDataMgr.write((OutputStream)System.out, (Model)model, (Lang)lang);
        System.out.println("## Write by Model.write");
        model.write((OutputStream)System.out, "SSE");
    }

    static {
        LogCtl.setLogging();
    }

    static class SSEWriterFactory
    implements WriterGraphRIOTFactory {
        SSEWriterFactory() {
        }

        public WriterGraphRIOT create(RDFFormat syntaxForm) {
            return new SSEWriter();
        }
    }

    public static class RDFWriterSSE
    extends RDFWriterRIOT {
        public RDFWriterSSE() {
            super("SSE");
        }
    }

    static class SSEWriter
    extends WriterGraphRIOTBase {
        SSEWriter() {
        }

        public void write(OutputStream out, Graph graph, PrefixMap prefixMap, String baseURI, Context context) {
            SSE.write((OutputStream)out, (Graph)graph);
        }

        public Lang getLang() {
            return RDFLanguages.contentTypeToLang((String)"text/x-sse");
        }

        public void write(Writer out, Graph graph, PrefixMap prefixMap, String baseURI, Context context) {
            IndentedWriter x = RiotLib.create((Writer)out);
            SSE.write((IndentedWriter)x, (Graph)graph);
        }
    }
}

