/*
 * Decompiled with CFR 0.152.
 */
package arq.examples;

import java.util.Objects;
import org.apache.jena.atlas.web.AuthScheme;
import org.apache.jena.fuseki.auth.Auth;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.main.JettySecurityLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.eclipse.jetty.ee10.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserStore;

public class ExamplesServer {
    public static FusekiServer startServer(String dsName, DatasetGraph dsg, boolean verbose) {
        FusekiServer server = FusekiServer.create().port(0).loopback(true).verbose(verbose).enablePing(true).add(dsName, dsg).build();
        server.start();
        return server;
    }

    public static FusekiServer startServerWithAuth(String dsName, DatasetGraph dsg, boolean verbose, String user, String password) {
        Objects.requireNonNull(user);
        Objects.requireNonNull(password);
        UserStore userStore = JettySecurityLib.makeUserStore((String)user, (String)password);
        ConstraintSecurityHandler sh = JettySecurityLib.makeSecurityHandler((String)"Fuseki", (UserStore)userStore, (AuthScheme)AuthScheme.BASIC);
        FusekiServer server = FusekiServer.create().port(0).loopback(true).verbose(verbose).enablePing(true).securityHandler((SecurityHandler)sh).serverAuthPolicy(Auth.policyAllowSpecific((String[])new String[]{user})).add(dsName, dsg).build();
        server.start();
        return server;
    }
}

