/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.example.pizza;

import org.apache.jena.example.Base;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDFS;

public class PizzaSparqlNoInf
extends Base {
    public static final String SOURCE = "./src/main/resources/data/";
    public static final String PIZZA_NS = "http://www.co-ode.org/ontologies/pizza/pizza.owl#";

    public static void main(String[] args) {
        new PizzaSparqlNoInf().setArgs(args).run();
    }

    @Override
    public void run() {
        OntModel m = this.getModel();
        this.loadData((Model)m);
        String prefix = "prefix pizza: <http://www.co-ode.org/ontologies/pizza/pizza.owl#>\nprefix rdfs: <" + RDFS.getURI() + ">\nprefix owl: <" + OWL.getURI() + ">\n";
        this.showQuery((Model)m, prefix + "select ?pizza where {?pizza a owl:Class ;                             rdfs:subClassOf ?restriction.\n                     ?restriction owl:onProperty pizza:hasTopping ;                            owl:someValuesFrom pizza:PeperoniSausageTopping}");
    }

    protected OntModel getModel() {
        return ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
    }

    protected void loadData(Model m) {
        RDFDataMgr.read((Model)m, (String)"./src/main/resources/data/pizza.owl.rdf");
    }

    protected void showQuery(Model m, String q) {
        Query query = QueryFactory.create((String)q);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)m);){
            ResultSet results = qexec.execSelect();
            ResultSetFormatter.out((ResultSet)results, (PrefixMapping)m);
        }
    }
}

