/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.example.helloworld;

import org.apache.jena.example.CheeseBase;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class HelloWorld
extends CheeseBase {
    public static void main(String[] args) {
        new HelloWorld().setArgs(args).run();
    }

    @Override
    public void run() {
        Model m = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)m, (String)"./src/main/resources/data/cheeses-0.1.ttl");
        this.showModelSize(m);
        this.listCheeses(m);
    }

    protected void showModelSize(Model m) {
        System.out.println(String.format("The model contains %d triples", m.size()));
    }

    protected void listCheeses(Model m) {
        Resource cheeseClass = m.getResource("http://data.kasabi.com/dataset/cheese/schema/Cheese");
        StmtIterator i = m.listStatements(null, RDF.type, (RDFNode)cheeseClass);
        while (i.hasNext()) {
            Resource cheese = ((Statement)i.next()).getSubject();
            String label = this.getEnglishLabel(cheese);
            System.out.println(String.format("Cheese %s has name: %s", cheese.getURI(), label));
        }
    }

    protected String getEnglishLabel(Resource cheese) {
        StmtIterator i = cheese.listProperties(RDFS.label);
        while (i.hasNext()) {
            Literal l = ((Statement)i.next()).getLiteral();
            if (l.getLanguage() == null || !l.getLanguage().equals("en")) continue;
            return l.getLexicalForm();
        }
        return "A Cheese with No Name!";
    }

    protected String getValueAsString(Resource r, Property p) {
        Statement s = r.getProperty(p);
        if (s == null) {
            return "";
        }
        return s.getObject().isResource() ? s.getResource().getURI() : s.getString();
    }
}

