/*
 * Decompiled with CFR 0.152.
 */
package arq.examples.auth;

import arq.examples.ExamplesServer;
import java.net.Authenticator;
import java.net.URI;
import java.net.http.HttpClient;
import java.time.Duration;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.system.FusekiLogging;
import org.apache.jena.http.auth.AuthEnv;
import org.apache.jena.http.auth.AuthLib;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionRemote;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;

public class ExAuth01_RDFConnectionPW {
    static String dsName = "data";
    static DatasetGraph dsg = DatasetGraphFactory.createTxnMem();
    static FusekiServer server;
    static String serverURL;
    static String dataURL;
    public static String rdfString;
    static Model someData;

    public static void main(String ... args) {
        try {
            FusekiLogging.setLogging();
            server = ExamplesServer.startServerWithAuth(dsName, dsg, true, "u", "p");
            serverURL = "http://localhost:" + server.getPort() + "/";
            dataURL = "http://localhost:" + server.getPort() + "/" + dsName;
            RDFParser.fromString((String)rdfString, (Lang)Lang.TTL).parse(someData);
            ExAuth01_RDFConnectionPW.exampleConnectionAuthWithHttpClient();
            ExAuth01_RDFConnectionPW.exampleConnectionAuthByRegistration();
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        finally {
            System.exit(0);
        }
    }

    public static void exampleConnectionAuthWithHttpClient() {
        System.out.println();
        System.out.println("HttpClient + RDFConnectionRemote");
        Authenticator authenticator = AuthLib.authenticator((String)"u", (String)"p");
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).authenticator(authenticator).build();
        try (RDFConnection conn = RDFConnectionRemote.service((String)dataURL).httpClient(httpClient).build();){
            conn.update("INSERT DATA{}");
            conn.queryAsk("ASK{}");
        }
    }

    public static void exampleConnectionAuthByRegistration() {
        System.out.println();
        System.out.println("Register user/password + RDFConnectionRemote");
        AuthEnv.get().registerUsernamePassword(URI.create(dataURL), "u", "p");
        try (RDFConnection conn1 = RDFConnectionRemote.service((String)dataURL).build();){
            System.out.println("conn1: Try to PUT model ...");
            conn1.put(someData);
        }
    }

    static {
        rdfString = StrUtils.strjoinNL((String[])new String[]{"PREFIX : <http://example>", ":s :p 123 ."});
        someData = ModelFactory.createDefaultModel();
    }
}

