/*
 * Decompiled with CFR 0.152.
 */
package arq.examples;

import java.io.OutputStream;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.update.UpdateExecution;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public class ExQuerySubstitute_01 {
    private static String prefixes = StrUtils.strjoinNL((String[])new String[]{"PREFIX rdf:     <http://www.w3.org/1999/02/22-rdf-syntax-ns#>", "PREFIX rdfs:    <http://www.w3.org/2000/01/rdf-schema#>", "PREFIX xsd:     <http://www.w3.org/2001/XMLSchema#>", "PREFIX foaf:    <http://xmlns.com/foaf/0.1/>", ""});

    public static void main(String ... args) {
        Dataset dataset = DatasetFactory.createTxnMem();
        dataset.getPrefixMapping().setNsPrefix("foaf", "http://xmlns.com/foaf/0.1/");
        ExQuerySubstitute_01.addPerson(dataset, "http://example/carl_segan", "Carl Segan");
        ExQuerySubstitute_01.addPerson(dataset, "http://example/richard_feyman", "Richard Feynman");
        System.out.println("-- Data");
        RDFDataMgr.write((OutputStream)System.out, (Dataset)dataset, (Lang)Lang.TRIG);
        System.out.println("--");
        Literal name1 = ResourceFactory.createPlainLiteral((String)"Carl Segan");
        Literal name2 = ResourceFactory.createPlainLiteral((String)"Richard Feynman");
        ResultSet resultSet1 = QueryExecution.dataset((Dataset)dataset).query(prefixes + "SELECT * { ?person foaf:name ?name }").substitution("name", (RDFNode)name1).select();
        ResultSetFormatter.out((ResultSet)resultSet1);
        ResultSet resultSet2 = QueryExecution.dataset((Dataset)dataset).query(prefixes + "SELECT ?person ?name { ?person foaf:name ?name }").substitution("name", (RDFNode)name2).select();
        ResultSetFormatter.out((ResultSet)resultSet2);
    }

    private static void addPerson(Dataset dataset, String uri, String name) {
        UpdateRequest update = UpdateFactory.create((String)(prefixes + "INSERT { ?person foaf:name ?name } WHERE {}"));
        Resource person = ResourceFactory.createResource((String)uri);
        Literal literal = ResourceFactory.createPlainLiteral((String)name);
        UpdateExecution.dataset((Dataset)dataset).update(update).substitution("person", (RDFNode)person).substitution("name", (RDFNode)literal).execute();
    }
}

