/*
 * Decompiled with CFR 0.152.
 */
package tdb1.examples;

import java.util.Iterator;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.tdb1.TDB1;
import org.apache.jena.tdb1.TDB1Factory;

public class ExTDB6 {
    public static final String MY_NS = "x-ns://example.org/ns1/";

    public static void main(String[] args) throws Exception {
        TDB1.setOptimizerWarningFlag((boolean)false);
        String DATASET_DIR_NAME = "data0";
        Dataset data0 = TDB1Factory.createDataset((String)"data0");
        Iterator it = data0.listNames();
        while (it.hasNext()) {
            System.out.println("NAME=" + (String)it.next());
        }
        System.out.println("getting named model...");
        Model model = data0.getNamedModel(MY_NS);
        System.out.println("Model := " + String.valueOf(model));
        System.out.println("getting graph...");
        Graph graph = model.getGraph();
        System.out.println("Graph := " + String.valueOf(graph));
        if (graph.isEmpty()) {
            Resource product1 = model.createResource("x-ns://example.org/ns1/product/1");
            Property hasName = model.createProperty(MY_NS, "#hasName");
            Statement stmt = model.createStatement(product1, hasName, (RDFNode)model.createLiteral("Beach Ball", "en"));
            System.out.println("Statement = " + String.valueOf(stmt));
            model.add(stmt);
            System.out.println("Triple := " + stmt.asTriple().toString());
        } else {
            System.out.println("Graph is not Empty; it has " + graph.size() + " Statements");
            long t0 = System.currentTimeMillis();
            Query q = QueryFactory.create((String)"PREFIX exns: <x-ns://example.org/ns1/#>\nPREFIX exprod: <x-ns://example.org/ns1/product/>\n SELECT *  WHERE { ?res ?pred ?obj }");
            System.out.println("Query := " + String.valueOf(q));
            long t1 = System.currentTimeMillis();
            System.out.println("QueryFactory.TIME=" + (t1 - t0));
            t0 = System.currentTimeMillis();
            try (QueryExecution qExec = QueryExecutionFactory.create((Query)q, (Model)model);){
                t1 = System.currentTimeMillis();
                System.out.println("QueryExecutionFactory.TIME=" + (t1 - t0));
                t0 = System.currentTimeMillis();
                ResultSet rs = qExec.execSelect();
                t1 = System.currentTimeMillis();
                System.out.println("executeSelect.TIME=" + (t1 - t0));
                while (rs.hasNext()) {
                    QuerySolution sol = rs.next();
                    System.out.println("Solution := " + String.valueOf(sol));
                    Iterator names = sol.varNames();
                    while (names.hasNext()) {
                        String name = (String)names.next();
                        System.out.println("\t" + name + " := " + String.valueOf(sol.get(name)));
                    }
                }
            }
        }
        System.out.println("closing graph");
        graph.close();
        System.out.println("closing model");
        model.close();
        System.out.println("closing DataSet");
        data0.close();
    }
}

