/*
 * Decompiled with CFR 0.152.
 */
package arq.examples.update;

import java.io.OutputStream;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.modify.request.Target;
import org.apache.jena.sparql.modify.request.UpdateCreate;
import org.apache.jena.sparql.modify.request.UpdateDrop;
import org.apache.jena.sparql.modify.request.UpdateLoad;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateAction;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public class UpdateProgrammatic {
    public static void main(String[] args) {
        Dataset dataset = DatasetFactory.createTxnMem();
        UpdateRequest request = UpdateFactory.create();
        request.add((Update)new UpdateDrop(Target.ALL));
        request.add((Update)new UpdateCreate("http://example/g2"));
        request.add((Update)new UpdateLoad("file:etc/update-data.ttl", "http://example/g2"));
        UpdateAction.execute((UpdateRequest)request, (Dataset)dataset);
        System.out.println("# Debug format");
        SSE.write((Dataset)dataset);
        System.out.println();
        System.out.println("# N-Quads: S P O G");
        RDFDataMgr.write((OutputStream)System.out, (Dataset)dataset, (Lang)Lang.NQUADS);
    }

    static {
        LogCtl.setLogging();
    }
}

