/*
 * Decompiled with CFR 0.152.
 */
package tdb.tools;

import arq.cmdline.CmdARQ;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Node_Literal;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.tdb.base.file.FileFactory;
import org.apache.jena.tdb.base.file.FileSet;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.base.objectfile.ObjectFile;
import org.apache.jena.tdb.lib.NodeLib;
import org.apache.jena.tdb.setup.StoreParams;
import org.apache.jena.tdb.store.NodeId;
import tdb.cmdline.ModLocation;

public class dumpnodes
extends CmdARQ {
    ModLocation modLocation = new ModLocation();

    public static void main(String ... argv) {
        LogCtl.setLog4j();
        new dumpnodes(argv).mainRun();
    }

    @Override
    protected void exec() {
        Location loc = this.modLocation.getLocation();
        ObjectFile objFile = this.determineNodeTable(loc);
        dumpnodes.dump(System.out, objFile);
    }

    private ObjectFile determineNodeTable(Location loc) {
        StoreParams storeParams = StoreParams.getDftStoreParams();
        FileSet fsId2Node = new FileSet(loc, storeParams.getIndexId2Node());
        String file = fsId2Node.filename("dat");
        ObjectFile objFile = FileFactory.createObjectFileDisk((String)file);
        return objFile;
    }

    protected dumpnodes(String[] argv) {
        super(argv);
        super.addModule(this.modLocation);
    }

    private static Iterator<Pair<NodeId, Node>> all(ObjectFile objFile) {
        Iterator objs = objFile.all();
        Function<Pair, Pair> transform = item -> {
            NodeId id = NodeId.create((long)((Long)item.car()));
            ByteBuffer bb = (ByteBuffer)item.cdr();
            Node n = NodeLib.decode((ByteBuffer)bb);
            return new Pair((Object)id, (Object)n);
        };
        return Iter.map((Iterator)objs, transform);
    }

    public static void dump(OutputStream w, ObjectFile objFile) {
        Iterator<Pair<NodeId, Node>> iter = dumpnodes.all(objFile);
        long count = 0L;
        try (IndentedWriter iw = new IndentedWriter(w);){
            if (!iter.hasNext()) {
                iw.println("No nodes in the .dat file");
                return;
            }
            while (iter.hasNext()) {
                Pair<NodeId, Node> pair = iter.next();
                iw.print(((NodeId)pair.car()).toString());
                iw.print(" : ");
                Node n = (Node)pair.cdr();
                String $ = dumpnodes.stringForNode(n);
                iw.print($);
                iw.println();
                ++count;
            }
            iw.println();
            iw.printf("Total: " + count, new Object[0]);
            iw.println();
            iw.flush();
        }
    }

    private static String stringForNode(Node n) {
        if (n == null) {
            return "<<null>>";
        }
        if (n.isBlank()) {
            return "_:" + n.getBlankNodeLabel();
        }
        if (n.isLiteral()) {
            return dumpnodes.stringForLiteral((Node_Literal)n);
        }
        if (n.isURI()) {
            String uri = n.getURI();
            return dumpnodes.stringForURI(uri);
        }
        if (n.isVariable()) {
            return "?" + n.getName();
        }
        if (n.equals((Object)Node.ANY)) {
            return "ANY";
        }
        Log.warn(FmtUtils.class, (String)("Failed to turn a node into a string: " + n));
        return n.toString();
    }

    public static String stringForURI(String uri) {
        return "<" + uri + ">";
    }

    public static String stringForLiteral(Node_Literal literal) {
        String datatype = literal.getLiteralDatatypeURI();
        String lang = literal.getLiteralLanguage();
        String s = literal.getLiteralLexicalForm();
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("\"");
        FmtUtils.stringEsc((StringBuilder)sbuff, (String)s, (boolean)true);
        sbuff.append("\"");
        if (lang != null && lang.length() > 0) {
            sbuff.append("@");
            sbuff.append(lang);
        }
        if (datatype != null) {
            sbuff.append("^^");
            sbuff.append(dumpnodes.stringForURI(datatype));
        }
        return sbuff.toString();
    }

    @Override
    protected void processModulesAndArgs() {
        if (this.modVersion.getVersionFlag()) {
            this.modVersion.printVersionAndExit();
        }
        if (this.modLocation.getLocation() == null) {
            this.cmdError("Location required");
        }
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " --loc=DIR IndexName";
    }

    @Override
    protected String getCommandName() {
        return Lib.className((Object)this);
    }
}

