
package org.jclouds.googlecloudstorage.domain;

import java.util.List;
import javax.annotation.Generated;
import org.jclouds.javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_Bucket_Cors extends Bucket.Cors {

  private final List<String> origin;
  private final List<String> method;
  private final List<String> responseHeader;
  private final Integer maxAgeSeconds;

  AutoValue_Bucket_Cors(
      List<String> origin,
      List<String> method,
      List<String> responseHeader,
      @Nullable Integer maxAgeSeconds) {
    if (origin == null) {
      throw new NullPointerException("Null origin");
    }
    this.origin = origin;
    if (method == null) {
      throw new NullPointerException("Null method");
    }
    this.method = method;
    if (responseHeader == null) {
      throw new NullPointerException("Null responseHeader");
    }
    this.responseHeader = responseHeader;
    this.maxAgeSeconds = maxAgeSeconds;
  }

  @Override
  public List<String> origin() {
    return origin;
  }

  @Override
  public List<String> method() {
    return method;
  }

  @Override
  public List<String> responseHeader() {
    return responseHeader;
  }

  @Nullable
  @Override
  public Integer maxAgeSeconds() {
    return maxAgeSeconds;
  }

  @Override
  public String toString() {
    return "Cors{"
        + "origin=" + origin + ", "
        + "method=" + method + ", "
        + "responseHeader=" + responseHeader + ", "
        + "maxAgeSeconds=" + maxAgeSeconds
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Bucket.Cors) {
      Bucket.Cors that = (Bucket.Cors) o;
      return (this.origin.equals(that.origin()))
           && (this.method.equals(that.method()))
           && (this.responseHeader.equals(that.responseHeader()))
           && ((this.maxAgeSeconds == null) ? (that.maxAgeSeconds() == null) : this.maxAgeSeconds.equals(that.maxAgeSeconds()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.origin.hashCode();
    h *= 1000003;
    h ^= this.method.hashCode();
    h *= 1000003;
    h ^= this.responseHeader.hashCode();
    h *= 1000003;
    h ^= (maxAgeSeconds == null) ? 0 : this.maxAgeSeconds.hashCode();
    return h;
  }

}
