/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import java.util.Map;
import org.jclouds.azurecompute.arm.domain.Vault;
import org.jclouds.azurecompute.arm.domain.VaultProperties;
import org.jclouds.javax.annotation.Nullable;

final class AutoValue_Vault
extends Vault {
    private final String id;
    private final String type;
    private final String location;
    private final Map<String, String> tags;
    private final String name;
    private final VaultProperties properties;

    private AutoValue_Vault(@Nullable String id, @Nullable String type, String location, @Nullable Map<String, String> tags, @Nullable String name, VaultProperties properties) {
        this.id = id;
        this.type = type;
        this.location = location;
        this.tags = tags;
        this.name = name;
        this.properties = properties;
    }

    @Override
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @Nullable
    public String type() {
        return this.type;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    @Nullable
    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    public VaultProperties properties() {
        return this.properties;
    }

    public String toString() {
        return "Vault{id=" + this.id + ", " + "type=" + this.type + ", " + "location=" + this.location + ", " + "tags=" + this.tags + ", " + "name=" + this.name + ", " + "properties=" + this.properties + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Vault) {
            Vault that = (Vault)o;
            return (this.id == null ? that.id() == null : this.id.equals(that.id())) && (this.type == null ? that.type() == null : this.type.equals(that.type())) && this.location.equals(that.location()) && (this.tags == null ? that.tags() == null : this.tags.equals(that.tags())) && (this.name == null ? that.name() == null : this.name.equals(that.name())) && this.properties.equals(that.properties());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.id == null ? 0 : this.id.hashCode();
        h *= 1000003;
        h ^= this.type == null ? 0 : this.type.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.tags == null ? 0 : this.tags.hashCode();
        h *= 1000003;
        h ^= this.name == null ? 0 : this.name.hashCode();
        h *= 1000003;
        return h ^= this.properties.hashCode();
    }

    @Override
    public Vault.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Vault.Builder {
        private String id;
        private String type;
        private String location;
        private Map<String, String> tags;
        private String name;
        private VaultProperties properties;

        Builder() {
        }

        private Builder(Vault source) {
            this.id = source.id();
            this.type = source.type();
            this.location = source.location();
            this.tags = source.tags();
            this.name = source.name();
            this.properties = source.properties();
        }

        @Override
        public Vault.Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @Override
        public Vault.Builder type(@Nullable String type) {
            this.type = type;
            return this;
        }

        @Override
        public Vault.Builder location(String location) {
            if (location == null) {
                throw new NullPointerException("Null location");
            }
            this.location = location;
            return this;
        }

        @Override
        public Vault.Builder tags(@Nullable Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        @Override
        @Nullable
        Map<String, String> tags() {
            return this.tags;
        }

        @Override
        public Vault.Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @Override
        public Vault.Builder properties(VaultProperties properties) {
            if (properties == null) {
                throw new NullPointerException("Null properties");
            }
            this.properties = properties;
            return this;
        }

        @Override
        Vault autoBuild() {
            String missing = "";
            if (this.location == null) {
                missing = missing + " location";
            }
            if (this.properties == null) {
                missing = missing + " properties";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Vault(this.id, this.type, this.location, this.tags, this.name, this.properties);
        }
    }
}

