/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.config.ValueOfConfigurationKeyOrNull;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.endpoints.Catalog;
import org.jclouds.vcloud.suppliers.OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault;

@Singleton
public class DefaultCatalogForOrg
implements Function<ReferenceType, ReferenceType> {
    private final OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault selector;
    private final Supplier<Map<String, Org>> nameToOrg;

    @Inject
    public DefaultCatalogForOrg(ValueOfConfigurationKeyOrNull valueOfConfigurationKeyOrNull, @Catalog Predicate<ReferenceType> defaultSelector, Supplier<Map<String, Org>> nameToOrg) {
        this.selector = new OnlyReferenceTypeFirstWithNameMatchingConfigurationKeyOrDefault((ValueOfConfigurationKeyOrNull)Preconditions.checkNotNull((Object)valueOfConfigurationKeyOrNull, (Object)"valueOfConfigurationKeyOrNull"), "jclouds.vcloud.defaults.catalog", (Predicate<ReferenceType>)((Predicate)Preconditions.checkNotNull(defaultSelector, (Object)"defaultSelector")));
        this.nameToOrg = (Supplier)Preconditions.checkNotNull(nameToOrg, (Object)"nameToOrg");
    }

    public ReferenceType apply(ReferenceType defaultOrg) {
        Org org = (Org)((Map)this.nameToOrg.get()).get(defaultOrg.getName());
        Preconditions.checkState((org != null ? 1 : 0) != 0, (String)"could not retrieve Org at %s", (Object[])new Object[]{defaultOrg});
        return this.selector.apply(org.getCatalogs().values());
    }
}

