/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute;

import com.google.common.base.Function;
import com.google.inject.Module;
import java.net.URI;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeService;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.internal.BaseRestApiExpectTest;
import org.jclouds.vcloud.VCloudApiMetadata;

public abstract class BaseVCloudComputeServiceExpectTest
extends BaseRestApiExpectTest<ComputeService> {
    protected static final String ENDPOINT = "https://zone.myvcloud.com/api";
    protected HttpRequest versionsRequest = HttpRequest.builder().method("GET").endpoint(URI.create("https://zone.myvcloud.com/api/versions")).build();
    protected HttpResponse versionsResponseFromVCD1_5 = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("HTTP/1.1 200 OK").payload(this.payloadFromResourceWithContentType("/versions-vcd15.xml", "text/xml"))).build();
    protected HttpRequest version1_0LoginRequest = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://zone.myvcloud.com/api/v1.0/login").addHeader("Accept", new String[]{"application/vnd.vmware.vcloud.orgList+xml"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).build();
    protected String sessionToken = "AtatAgvJMrwOc9pDQq4RRCRLazThpnTKJDxSVH9oB2I=";
    protected HttpResponse successfulVersion1_0LoginResponseFromVCD1_5WithSingleOrg = ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("HTTP/1.1 200 OK").payload(this.payloadFromResourceWithContentType("/orgList1.0-vcd15.xml", "application/vnd.vmware.vcloud.orgList+xml;version=1.0"))).addHeader("x-vcloud-authorization", new String[]{this.sessionToken})).addHeader("Set-Cookie", new String[]{String.format("vcloud-token=%s; Secure; Path=/", this.sessionToken)})).build();
    protected String orgId = "c076f90a-397a-49fa-89b8-b294c1599cd0";
    protected HttpRequest version1_0GetOrgRequest = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://zone.myvcloud.com/api/v1.0/org/" + this.orgId).addHeader("Accept", new String[]{"application/vnd.vmware.vcloud.org+xml"})).addHeader("x-vcloud-authorization", new String[]{this.sessionToken})).addHeader("Cookie", new String[]{"vcloud-token=" + this.sessionToken})).build();
    protected HttpResponse successfulVersion1_0GetOrgResponseFromVCD1_5WithSingleTasksListVDCAndNetwork = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("HTTP/1.1 200 OK").payload(this.payloadFromResourceWithContentType("/org1.0-vcd15.xml", "application/vnd.vmware.vcloud.org+xml;version=1.0"))).build();
    protected String catalogId = "3155f393-1e1d-4572-8c9c-d76f72ddb658";
    protected String vdcId = "e9cd3387-ac57-4d27-a481-9bee75e0690f";
    protected HttpRequest version1_0GetCatalogRequest = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://zone.myvcloud.com/api/v1.0/catalog/" + this.catalogId).addHeader("Accept", new String[]{"application/vnd.vmware.vcloud.catalog+xml"})).addHeader("x-vcloud-authorization", new String[]{this.sessionToken})).addHeader("Cookie", new String[]{"vcloud-token=" + this.sessionToken})).build();
    protected HttpResponse successfulVersion1_0GetCatalogResponseFromVCD1_5WithSingleTemplate = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("HTTP/1.1 200 OK").payload(this.payloadFromResourceWithContentType("/catalog1.0-vcd15.xml", "application/vnd.vmware.vcloud.catalog+xml;version=1.0"))).build();
    protected String catalogItemId = "ceb369f7-1d07-4e32-9dbd-ebb5aa6ca55c";
    protected HttpRequest version1_0GetCatalogItemRequest = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://zone.myvcloud.com/api/v1.0/catalogItem/" + this.catalogItemId).addHeader("Accept", new String[]{"application/vnd.vmware.vcloud.catalogItem+xml"})).addHeader("x-vcloud-authorization", new String[]{this.sessionToken})).addHeader("Cookie", new String[]{"vcloud-token=" + this.sessionToken})).build();
    protected HttpResponse successfulVersion1_0GetCatalogItemResponseFromVCD1_5ForTemplate = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("HTTP/1.1 200 OK").payload(this.payloadFromResourceWithContentType("/catalogItem1.0-vcd15.xml", "application/vnd.vmware.vcloud.catalogItem+xml;version=1.0"))).build();
    protected String templateId = "vappTemplate-51891b97-c5dd-47dc-a687-aabae354f728";
    protected HttpRequest version1_0GetVDCRequest = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://zone.myvcloud.com/api/v1.0/vdc/" + this.vdcId).addHeader("Accept", new String[]{"application/vnd.vmware.vcloud.vdc+xml"})).addHeader("x-vcloud-authorization", new String[]{this.sessionToken})).addHeader("Cookie", new String[]{"vcloud-token=" + this.sessionToken})).build();
    protected HttpResponse successfulVersion1_0GetVDCResponseFromVCD1_5WithSingleTemplateAndNetwork = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("HTTP/1.1 200 OK").payload(this.payloadFromResourceWithContentType("/vdc1.0-vcd15.xml", "application/vnd.vmware.vcloud.vdc+xml;version=1.0"))).build();
    protected String networkId = "b466c0c5-8a5c-4335-b703-a2e2e6b5f3e1";
    protected HttpRequest version1_0GetVAppTemplateRequest = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://zone.myvcloud.com/api/v1.0/vAppTemplate/" + this.templateId).addHeader("Accept", new String[]{"application/vnd.vmware.vcloud.vAppTemplate+xml"})).addHeader("x-vcloud-authorization", new String[]{this.sessionToken})).addHeader("Cookie", new String[]{"vcloud-token=" + this.sessionToken})).build();
    protected HttpResponse successfulVersion1_0GetVAppTemplateResponseFromVCD1_5WithSingleVMAndVDCParent = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("HTTP/1.1 200 OK").payload(this.payloadFromResourceWithContentType("/template1.0-vcd15.xml", "application/vnd.vmware.vcloud.vAppTemplate+xml;version=1.0"))).build();
    protected HttpResponse successfulVersion1_0GetVAppTemplateResponseFromVCD1_5WithMultipleVMsAndVDCParent = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("HTTP/1.1 200 OK").payload(this.payloadFromResourceWithContentType("/template1.0-vcd15-multi-vm.xml", "application/vnd.vmware.vcloud.vAppTemplate+xml;version=1.0"))).build();
    protected HttpRequest version1_0GetOVFForVAppTemplateRequest = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://zone.myvcloud.com/api/v1.0/vAppTemplate/" + this.templateId + "/ovf").addHeader("Accept", new String[]{"text/xml"})).addHeader("x-vcloud-authorization", new String[]{this.sessionToken})).addHeader("Cookie", new String[]{"vcloud-token=" + this.sessionToken})).build();
    protected HttpResponse successfulVersion1_0GetOVFForVAppTemplateResponseFromVCD1_5WithSingleVM = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("HTTP/1.1 200 OK").payload(this.payloadFromResourceWithContentType("/ovf-ubuntu64.xml", "text/xml;version=1.0"))).build();
    protected HttpResponse successfulVersion1_0GetOVFForVAppTemplateResponseFromVCD1_5WithMultipleVMs = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("HTTP/1.1 200 OK").payload(this.payloadFromResourceWithContentType("/ovf-multi-vm.xml", "text/xml;version=1.0"))).build();

    public BaseVCloudComputeServiceExpectTest() {
        this.provider = "vcloud";
    }

    public ComputeService createClient(Function<HttpRequest, HttpResponse> fn, Module module, Properties props) {
        return (ComputeService)this.createInjector(fn, module, props).getInstance(ComputeService.class);
    }

    protected ApiMetadata createApiMetadata() {
        return new VCloudApiMetadata();
    }

    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        props.setProperty(this.provider + ".endpoint", ENDPOINT);
        return props;
    }
}

