/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.VCloudApi;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.VAppTemplate;

@Singleton
public class VAppTemplatesForCatalogItems
implements Function<Iterable<CatalogItem>, Iterable<VAppTemplate>> {
    @Resource
    @Named(value="jclouds.compute")
    private Logger logger = Logger.NULL;
    private final VCloudApi aclient;

    @Inject
    VAppTemplatesForCatalogItems(VCloudApi aclient) {
        this.aclient = aclient;
    }

    public Iterable<VAppTemplate> apply(Iterable<CatalogItem> from) {
        return Iterables.filter((Iterable)Iterables.transform((Iterable)Iterables.filter(from, (Predicate)new Predicate<CatalogItem>(){

            public boolean apply(CatalogItem input) {
                return input.getEntity().getType().equals("application/vnd.vmware.vcloud.vAppTemplate+xml");
            }
        }), (Function)new Function<CatalogItem, VAppTemplate>(){

            public VAppTemplate apply(CatalogItem from) {
                return VAppTemplatesForCatalogItems.this.aclient.getVAppTemplateApi().getVAppTemplate(from.getEntity().getHref());
            }
        }), (Predicate)Predicates.notNull());
    }
}

