/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.binders;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.easymock.EasyMock;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.Strings2;
import org.jclouds.vcloud.VCloudApiMetadata;
import org.jclouds.vcloud.binders.BindInstantiateVAppTemplateParamsToXmlPayload;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VAppTemplate;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.NetworkConfig;
import org.jclouds.vcloud.endpoints.Network;
import org.jclouds.vcloud.internal.BasePayloadTest;
import org.jclouds.vcloud.options.InstantiateVAppTemplateOptions;
import org.nnsoft.guice.rocoto.Rocoto;
import org.nnsoft.guice.rocoto.configuration.ConfigurationModule;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindInstantiateVAppTemplateParamsToXmlPayloadTest
extends BasePayloadTest {
    Injector createInjector(final URI vAppTemplate, final VAppTemplate value) {
        return Guice.createInjector((Module[])new Module[]{Rocoto.expandVariables((Module[])new Module[]{new ConfigurationModule(){

            @Provides
            @Singleton
            @Network
            protected Function<VAppTemplate, String> templateToDefaultNetworkName() {
                return Functions.forMap((Map)ImmutableMap.of((Object)value, (Object)"vAppNet-vApp Internal"));
            }

            @Provides
            @Singleton
            protected LoadingCache<URI, VAppTemplate> templateIdToVAppTemplate() {
                return CacheBuilder.newBuilder().build(CacheLoader.from((Function)Functions.forMap((Map)ImmutableMap.of((Object)vAppTemplate, (Object)value))));
            }

            protected void bindConfigurations() {
                this.bindProperties(new VCloudApiMetadata().getDefaultProperties());
            }

            @Provides
            @Singleton
            public FenceMode defaultFenceMode(@Named(value="jclouds.vcloud.defaults.fencemode") String fenceMode) {
                return FenceMode.fromValue((String)fenceMode);
            }

            @Network
            @Provides
            @Singleton
            Supplier<ReferenceType> provideNetwork() {
                return Suppliers.ofInstance((Object)new ReferenceTypeImpl(null, null, URI.create("https://vcenterprise.bluelock.com/api/v1.0/network/1990")));
            }
        }})});
    }

    public void testDefault() throws IOException {
        URI templateUri = URI.create("https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/3");
        VAppTemplate template = (VAppTemplate)EasyMock.createMock(VAppTemplate.class);
        EasyMock.replay((Object[])new Object[]{template});
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/instantiationparams.xml"));
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of((Object)new InstantiateVAppTemplateOptions()));
        BindInstantiateVAppTemplateParamsToXmlPayload binder = (BindInstantiateVAppTemplateParamsToXmlPayload)this.createInjector(templateUri, template).getInstance(BindInstantiateVAppTemplateParamsToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        map.put("name", "my-vapp");
        map.put("template", templateUri.toASCIIString());
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map)).getPayload().getRawContent(), (Object)expected);
    }

    public void testDescription() throws IOException {
        URI templateUri = URI.create("https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/3");
        VAppTemplate template = (VAppTemplate)EasyMock.createMock(VAppTemplate.class);
        EasyMock.replay((Object[])new Object[]{template});
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/instantiationparams-description.xml"));
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of((Object)new InstantiateVAppTemplateOptions().description("my foo")));
        BindInstantiateVAppTemplateParamsToXmlPayload binder = (BindInstantiateVAppTemplateParamsToXmlPayload)this.createInjector(templateUri, template).getInstance(BindInstantiateVAppTemplateParamsToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        map.put("name", "my-vapp");
        map.put("template", templateUri.toASCIIString());
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map)).getPayload().getRawContent(), (Object)expected);
    }

    public void testWhenTemplateDoesntExist() throws IOException {
        URI templateUri = URI.create("https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/3");
        VAppTemplate template = (VAppTemplate)EasyMock.createMock(VAppTemplate.class);
        EasyMock.replay((Object[])new Object[]{template});
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/instantiationparams.xml"));
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of());
        BindInstantiateVAppTemplateParamsToXmlPayload binder = (BindInstantiateVAppTemplateParamsToXmlPayload)this.createInjector(templateUri, template).getInstance(BindInstantiateVAppTemplateParamsToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        map.put("name", "my-vapp");
        map.put("template", templateUri.toASCIIString());
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map)).getPayload().getRawContent(), (Object)expected);
    }

    public void testWithNetworkNameFenceMode() throws IOException {
        URI templateUri = URI.create("https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/3");
        VAppTemplate template = (VAppTemplate)EasyMock.createMock(VAppTemplate.class);
        EasyMock.replay((Object[])new Object[]{template});
        InstantiateVAppTemplateOptions options = InstantiateVAppTemplateOptions.Builder.addNetworkConfig((NetworkConfig)new NetworkConfig("aloha", URI.create("https://vcenterprise.bluelock.com/api/v1.0/network/1991"), FenceMode.NAT_ROUTED));
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/instantiationparams-network.xml"));
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of((Object)options));
        BindInstantiateVAppTemplateParamsToXmlPayload binder = (BindInstantiateVAppTemplateParamsToXmlPayload)this.createInjector(templateUri, template).getInstance(BindInstantiateVAppTemplateParamsToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        map.put("name", "my-vapp");
        map.put("template", "https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/3");
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map)).getPayload().getRawContent(), (Object)expected);
    }
}

