/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.CIMOperatingSystem;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.logging.Logger;
import org.jclouds.ovf.Envelope;
import org.jclouds.vcloud.compute.functions.FindLocationForResource;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.VAppTemplate;

@Singleton
public class ImageForVAppTemplate
implements Function<VAppTemplate, Image> {
    @Resource
    @Named(value="jclouds.compute")
    public Logger logger = Logger.NULL;
    private final Map<Status, Image.Status> toPortableImageStatus;
    private final Function<VAppTemplate, Envelope> templateToEnvelope;
    private final FindLocationForResource findLocationForResource;

    @Inject
    protected ImageForVAppTemplate(Map<Status, Image.Status> toPortableImageStatus, Function<VAppTemplate, Envelope> templateToEnvelope, FindLocationForResource findLocationForResource) {
        this.toPortableImageStatus = (Map)Preconditions.checkNotNull(toPortableImageStatus, (Object)"toPortableImageStatus");
        this.templateToEnvelope = (Function)Preconditions.checkNotNull(templateToEnvelope, (Object)"templateToEnvelope");
        this.findLocationForResource = (FindLocationForResource)Preconditions.checkNotNull((Object)findLocationForResource, (Object)"findLocationForResource");
    }

    public Image apply(VAppTemplate from) {
        Preconditions.checkNotNull((Object)from, (Object)"VAppTemplate");
        Envelope ovf = (Envelope)this.templateToEnvelope.apply((Object)from);
        ImageBuilder builder = new ImageBuilder();
        builder.ids(from.getHref().toASCIIString());
        builder.uri(from.getHref());
        builder.name(from.getName());
        if (from.getVDC() != null) {
            builder.location(this.findLocationForResource.apply(from.getVDC()));
        }
        builder.description(from.getDescription() != null ? from.getDescription() : from.getName());
        builder.operatingSystem((OperatingSystem)CIMOperatingSystem.toComputeOs((Envelope)ovf));
        builder.status(this.toPortableImageStatus.get((Object)from.getStatus()));
        return builder.build();
    }
}

