/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.endpoints.Catalog;
import org.jclouds.vcloud.endpoints.Org;

@Singleton
public class OrgNameCatalogNameVAppTemplateNameToEndpoint
implements MapBinder {
    private final Supplier<Map<String, Map<String, Map<String, CatalogItem>>>> orgCatalogItemMap;
    private final Supplier<ReferenceType> defaultOrg;
    private final Supplier<ReferenceType> defaultCatalog;

    @Inject
    public OrgNameCatalogNameVAppTemplateNameToEndpoint(Supplier<Map<String, Map<String, Map<String, CatalogItem>>>> orgCatalogItemMap, @Org Supplier<ReferenceType> defaultOrg, @Catalog Supplier<ReferenceType> defaultCatalog) {
        this.orgCatalogItemMap = orgCatalogItemMap;
        this.defaultOrg = defaultOrg;
        this.defaultCatalog = defaultCatalog;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        Map orgCatalogItemMap;
        Object org = postParams.get("orgName");
        Object catalog = postParams.get("catalogName");
        Object catalogItem = postParams.get("itemName");
        if (org == null) {
            org = ((ReferenceType)this.defaultOrg.get()).getName();
        }
        if (catalog == null) {
            catalog = ((ReferenceType)this.defaultCatalog.get()).getName();
        }
        if (!(orgCatalogItemMap = (Map)this.orgCatalogItemMap.get()).containsKey(org)) {
            throw new NoSuchElementException("org: " + org + " not found in " + orgCatalogItemMap.keySet());
        }
        Map catalogs = (Map)orgCatalogItemMap.get(org);
        if (!catalogs.containsKey(catalog)) {
            throw new NoSuchElementException("catalog: " + org + "/" + catalog + " not found in " + catalogs.keySet());
        }
        Map catalogMap = (Map)catalogs.get(catalog);
        if (!catalogMap.containsKey(catalogItem)) {
            throw new NoSuchElementException("item: " + org + "/" + catalog + "/" + catalogItem + " not found in " + catalogMap.keySet());
        }
        CatalogItem item = (CatalogItem)catalogMap.get(catalogItem);
        URI endpoint = ((ReferenceType)Preconditions.checkNotNull((Object)item.getEntity(), (Object)("item: " + org + "/" + catalog + "/" + catalogItem + " has no entity"))).getHref();
        return (R)request.toBuilder().endpoint(endpoint).build();
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new IllegalStateException(this.getClass() + " needs parameters");
    }
}

