/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Properties;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.logging.Logger;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.vcloud.domain.GuestCustomizationSection;

@Singleton
public class BindGuestCustomizationSectionToXmlPayload
extends BindToStringPayload {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final String ns;
    protected final String schema;

    @Inject
    public BindGuestCustomizationSectionToXmlPayload(BindToStringPayload stringBinder, @Named(value="jclouds.vcloud.xml.ns") String ns, @Named(value="jclouds.vcloud.xml.schema") String schema) {
        this.ns = ns;
        this.schema = schema;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)payload, (Object)"GuestCustomizationSection") instanceof GuestCustomizationSection), (Object)"this binder is only valid for GuestCustomizationSection!");
        GuestCustomizationSection guest = (GuestCustomizationSection)GuestCustomizationSection.class.cast(payload);
        try {
            XMLBuilder guestCustomizationSection = XMLBuilder.create((String)"GuestCustomizationSection").a("xmlns", this.ns).a("xmlns:ovf", "http://schemas.dmtf.org/ovf/envelope/1").a("type", guest.getType()).a("href", guest.getHref().toASCIIString()).a("ovf:required", "false");
            guestCustomizationSection.e("ovf:Info").t(guest.getInfo());
            if (guest.isEnabled() != null) {
                guestCustomizationSection.e("Enabled").t(guest.isEnabled().toString());
            }
            if (guest.shouldChangeSid() != null) {
                guestCustomizationSection.e("ChangeSid").t(guest.shouldChangeSid().toString());
            }
            if (guest.getVirtualMachineId() != null) {
                guestCustomizationSection.e("VirtualMachineId").t(guest.getVirtualMachineId().toString());
            }
            if (guest.isJoinDomainEnabled() != null) {
                guestCustomizationSection.e("JoinDomainEnabled").t(guest.isJoinDomainEnabled().toString());
            }
            if (guest.shouldUseOrgSettings() != null) {
                guestCustomizationSection.e("UseOrgSettings").t(guest.shouldUseOrgSettings().toString());
            }
            if (guest.getDomainName() != null) {
                guestCustomizationSection.e("DomainName").t(guest.getDomainName().toString());
            }
            if (guest.getDomainUserName() != null) {
                guestCustomizationSection.e("DomainUserName").t(guest.getDomainUserName().toString());
            }
            if (guest.getDomainUserPassword() != null) {
                guestCustomizationSection.e("DomainUserPassword").t(guest.getDomainUserPassword().toString());
            }
            if (guest.isAdminPasswordEnabled() != null) {
                guestCustomizationSection.e("AdminPasswordEnabled").t(guest.isAdminPasswordEnabled().toString());
            }
            if (guest.isAdminPasswordAuto() != null) {
                guestCustomizationSection.e("AdminPasswordAuto").t(guest.isAdminPasswordAuto().toString());
            }
            if (guest.isResetPasswordRequired() != null) {
                guestCustomizationSection.e("ResetPasswordRequired").t(guest.isResetPasswordRequired().toString());
            }
            if (guest.getCustomizationScript() != null) {
                guestCustomizationSection.e("CustomizationScript").t(guest.getCustomizationScript());
            }
            if (guest.getComputerName() != null) {
                guestCustomizationSection.e("ComputerName").t(guest.getComputerName().toString());
            }
            if (guest.getEdit() != null) {
                guestCustomizationSection.e("Link").a("rel", "edit").a("type", guest.getType()).a("href", guest.getHref().toASCIIString());
            }
            Properties outputProperties = new Properties();
            outputProperties.put("omit-xml-declaration", "yes");
            request = super.bindToRequest(request, (Object)guestCustomizationSection.asString(outputProperties));
            request.getPayload().getContentMetadata().setContentType(guest.getType());
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        return request;
    }
}

