/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.binders;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.Strings2;
import org.jclouds.vcloud.binders.BindCloneVAppParamsToXmlPayload;
import org.jclouds.vcloud.internal.BasePayloadTest;
import org.jclouds.vcloud.options.CloneVAppOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindCloneVAppParamsToXmlPayloadTest
extends BasePayloadTest {
    public void testWithDescriptionDeployOn() throws Exception {
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/copyVApp.xml"));
        CloneVAppOptions options = new CloneVAppOptions().deploy().powerOn().description("The description of the new vApp");
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of((Object)options));
        BindCloneVAppParamsToXmlPayload binder = (BindCloneVAppParamsToXmlPayload)this.injector.getInstance(BindCloneVAppParamsToXmlPayload.class);
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"name", (Object)"new-linux-server");
        map.put((Object)"Source", (Object)"https://vcenterprise.bluelock.com/api/v1.0/vapp/201");
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map.build())).getPayload().getRawContent(), (Object)expected);
    }

    public void testWithDescriptionDeployOnSourceDelete() throws Exception {
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/moveVApp.xml"));
        CloneVAppOptions options = new CloneVAppOptions().deploy().powerOn().description("The description of the new vApp");
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of((Object)options));
        BindCloneVAppParamsToXmlPayload binder = (BindCloneVAppParamsToXmlPayload)this.injector.getInstance(BindCloneVAppParamsToXmlPayload.class);
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"name", (Object)"new-linux-server");
        map.put((Object)"Source", (Object)"https://vcenterprise.bluelock.com/api/v1.0/vapp/201");
        map.put((Object)"IsSourceDelete", (Object)"true");
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map.build())).getPayload().getRawContent(), (Object)expected);
    }

    public void testDefault() throws Exception {
        String expected = Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/copyVApp-default.xml"));
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of());
        BindCloneVAppParamsToXmlPayload binder = (BindCloneVAppParamsToXmlPayload)this.injector.getInstance(BindCloneVAppParamsToXmlPayload.class);
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"name", (Object)"my-vapp");
        map.put((Object)"Source", (Object)"https://vcenterprise.bluelock.com/api/v1.0/vapp/4181");
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map.build())).getPayload().getRawContent(), (Object)expected);
    }
}

