/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.SortedMap;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.internal.CatalogItemImpl;
import org.jclouds.vcloud.util.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CatalogItemHandler
extends ParseSax.HandlerWithResult<CatalogItem> {
    private StringBuilder currentText = new StringBuilder();
    protected ReferenceType catalogItem;
    protected ReferenceType entity;
    protected String description;
    protected String key;
    protected SortedMap<String, String> properties = Maps.newTreeMap();

    public CatalogItem getResult() {
        return new CatalogItemImpl(this.catalogItem.getName(), this.catalogItem.getHref(), this.description, this.entity, this.properties);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"CatalogItem")) {
            this.catalogItem = Utils.newReferenceType(attributes);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Entity")) {
            this.entity = Utils.newReferenceType(attributes);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Property")) {
            this.key = (String)attributes.get("key");
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"Description")) {
            this.description = this.currentOrNull();
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Property")) {
            this.properties.put(this.key, this.currentOrNull());
            this.key = null;
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }
}

