/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.VCloudAsyncClient;
import org.jclouds.vcloud.domain.Catalog;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;

@Singleton
public class CatalogsInOrg
implements Function<Org, Iterable<Catalog>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final VCloudAsyncClient aclient;
    private final ListeningExecutorService userExecutor;

    @Inject
    CatalogsInOrg(VCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.aclient = aclient;
        this.userExecutor = userExecutor;
    }

    public Iterable<Catalog> apply(Org org) {
        return FutureIterables.transformParallel(org.getCatalogs().values(), (Function)new Function<ReferenceType, ListenableFuture<? extends Catalog>>(){

            public ListenableFuture<Catalog> apply(ReferenceType from) {
                return CatalogsInOrg.this.aclient.getCatalogClient().getCatalog(from.getHref());
            }
        }, (ListeningExecutorService)this.userExecutor, null, (Logger)this.logger, (String)("catalogs in " + org.getName()));
    }
}

