/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.net.URI;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.VCloudAsyncClient;
import org.jclouds.vcloud.domain.Org;

@Singleton
public class OrgsForLocations
implements Function<Iterable<Location>, Iterable<Org>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final VCloudAsyncClient aclient;
    private final ListeningExecutorService userExecutor;

    @Inject
    OrgsForLocations(VCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.aclient = aclient;
        this.userExecutor = userExecutor;
    }

    public Iterable<Org> apply(Iterable<Location> from) {
        FluentIterable uris = FluentIterable.from(from).filter((Predicate)new Predicate<Location>(){

            public boolean apply(Location input) {
                return input.getScope() == LocationScope.ZONE;
            }
        }).transform((Function)new Function<Location, URI>(){

            public URI apply(Location from) {
                return URI.create(from.getParent().getId());
            }
        });
        return FutureIterables.transformParallel((Iterable)uris, (Function)new Function<URI, ListenableFuture<? extends Org>>(){

            public ListenableFuture<Org> apply(URI from) {
                return OrgsForLocations.this.aclient.getOrgClient().getOrg(from);
            }
        }, (ListeningExecutorService)this.userExecutor, null, (Logger)this.logger, (String)"organizations for uris");
    }
}

