/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.ovf.Network;
import org.jclouds.vcloud.domain.VAppTemplate;

@Singleton
public class DefaultNetworkNameInTemplate
implements Function<VAppTemplate, String> {
    @Resource
    protected Logger logger = Logger.NULL;

    public String apply(VAppTemplate vAppTemplate) {
        Preconditions.checkArgument((vAppTemplate != null ? 1 : 0) != 0, (Object)"vAppTemplate was null!");
        Set networks = vAppTemplate.getNetworkSection().getNetworks();
        Preconditions.checkArgument((networks.size() > 0 ? 1 : 0) != 0, (String)"no networks found in vAppTemplate %s", (Object[])new Object[]{vAppTemplate});
        if (networks.size() > 1) {
            this.logger.warn("multiple networks found for %s, choosing first from: %s", new Object[]{vAppTemplate.getName(), networks});
        }
        return ((Network)Iterables.get((Iterable)networks, (int)0)).getName();
    }
}

