/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.network.IpRange;

public class IpScope {
    private final boolean inherited;
    @Nullable
    private final String gateway;
    @Nullable
    private final String netmask;
    @Nullable
    private final String dns1;
    @Nullable
    private final String dns2;
    @Nullable
    private final String dnsSuffix;
    private final Set<IpRange> ipRanges = Sets.newLinkedHashSet();
    private final Set<String> allocatedIpAddresses = Sets.newLinkedHashSet();

    public IpScope(boolean inherited, @Nullable String gateway, @Nullable String netmask, @Nullable String dns1, @Nullable String dns2, @Nullable String dnsSuffix, Iterable<IpRange> ipRanges, Iterable<String> allocatedIpAddresses) {
        this.inherited = inherited;
        this.gateway = gateway;
        this.netmask = netmask;
        this.dns1 = dns1;
        this.dns2 = dns2;
        this.dnsSuffix = dnsSuffix;
        Iterables.addAll(this.ipRanges, (Iterable)((Iterable)Preconditions.checkNotNull(ipRanges, (Object)"ipRanges")));
        Iterables.addAll(this.allocatedIpAddresses, (Iterable)((Iterable)Preconditions.checkNotNull(allocatedIpAddresses, (Object)"allocatedIpAddresses")));
    }

    public boolean isInherited() {
        return this.inherited;
    }

    @Nullable
    public String getGateway() {
        return this.gateway;
    }

    @Nullable
    public String getNetmask() {
        return this.netmask;
    }

    @Nullable
    public String getDns1() {
        return this.dns1;
    }

    @Nullable
    public String getDns2() {
        return this.dns2;
    }

    @Nullable
    public String getDnsSuffix() {
        return this.dnsSuffix;
    }

    public Set<IpRange> getIpRanges() {
        return this.ipRanges;
    }

    public Set<String> getAllocatedIpAddresses() {
        return this.allocatedIpAddresses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpScope that = (IpScope)IpScope.class.cast(o);
        return Objects.equal((Object)this.inherited, (Object)that.inherited) && Objects.equal((Object)this.gateway, (Object)that.gateway) && Objects.equal((Object)this.netmask, (Object)that.netmask) && Objects.equal((Object)this.dns1, (Object)that.dns1) && Objects.equal((Object)this.dns2, (Object)that.dns2) && Objects.equal((Object)this.dnsSuffix, (Object)that.dnsSuffix) && Objects.equal(this.ipRanges, this.ipRanges) && Objects.equal(this.allocatedIpAddresses, this.allocatedIpAddresses);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.inherited, this.gateway, this.netmask, this.dns1, this.dns2, this.dnsSuffix, this.ipRanges, this.allocatedIpAddresses});
    }

    public String toString() {
        Objects.ToStringHelper helper = Objects.toStringHelper((String)"").omitNullValues().add("inherited", this.inherited).add("gateway", (Object)this.gateway).add("netmask", (Object)this.netmask).add("dns1", (Object)this.dns1).add("dns2", (Object)this.dns2).add("dnsSuffix", (Object)this.dnsSuffix);
        if (this.ipRanges.size() > 0) {
            helper.add("ipRanges", this.ipRanges);
        }
        if (this.allocatedIpAddresses.size() > 0) {
            helper.add("allocatedIpAddresses", this.allocatedIpAddresses);
        }
        return helper.toString();
    }
}

