/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.binders;

import com.google.inject.Inject;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToStringPayload;

@Singleton
public class BindParamsToXmlPayload
implements MapBinder {
    protected final String ns;
    protected final BindToStringPayload stringBinder;
    protected final String element;

    @Inject
    public BindParamsToXmlPayload(String element, BindToStringPayload stringBinder, @Named(value="jclouds.vcloud.xml.ns") String ns) {
        this.element = element;
        this.ns = ns;
        this.stringBinder = stringBinder;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        try {
            return (R)this.stringBinder.bindToRequest(request, (Object)this.generateXml(postParams));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String generateXml(Map<String, Object> postParams) throws ParserConfigurationException, FactoryConfigurationError, TransformerException {
        XMLBuilder rootBuilder = XMLBuilder.create((String)this.element);
        for (Map.Entry<String, Object> entry : postParams.entrySet()) {
            rootBuilder.a(entry.getKey(), (String)entry.getValue());
        }
        rootBuilder.a("xmlns", this.ns);
        Properties outputProperties = new Properties();
        outputProperties.put("omit-xml-declaration", "yes");
        return rootBuilder.asString(outputProperties);
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        throw new IllegalArgumentException("incorrect usage");
    }
}

