/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.domain.network.DhcpService;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.IpRange;
import org.jclouds.vcloud.domain.network.IpScope;
import org.jclouds.vcloud.domain.network.OrgNetwork;
import org.jclouds.vcloud.xml.OrgNetworkHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class OrgNetworkHandlerTest {
    public void testIsolated() {
        InputStream is = this.getClass().getResourceAsStream("/orgnetwork-isolated.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        OrgNetwork result = (OrgNetwork)factory.create((ParseSax.HandlerWithResult)injector.getInstance(OrgNetworkHandler.class)).parse(is);
        Assert.assertEquals((String)result.getName(), (String)"isolation01");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/network/990419644"));
        Assert.assertEquals((String)result.getType(), (String)"application/vnd.vmware.vcloud.network+xml");
        Assert.assertEquals((Object)result.getOrg(), (Object)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.org+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/org/9566014")));
        Assert.assertEquals((String)result.getDescription(), null);
        Assert.assertEquals((Collection)result.getTasks(), (Collection)ImmutableList.of());
        assert (result.getConfiguration() != null);
        Assert.assertEquals((Object)result.getConfiguration().getIpScope(), (Object)new IpScope(false, "192.168.15.1", "255.255.255.0", "23.172.173.113", null, null, (Iterable)ImmutableSet.of((Object)new IpRange("192.168.15.100", "192.168.15.199")), (Iterable)ImmutableSet.of()));
        Assert.assertEquals((Object)result.getConfiguration().getParentNetwork(), null);
        Assert.assertEquals((Object)result.getConfiguration().getFenceMode(), (Object)FenceMode.ISOLATED);
        assert (result.getConfiguration().getFeatures() != null);
        Assert.assertEquals((Object)result.getConfiguration().getFeatures().getDhcpService(), (Object)new DhcpService(false, Integer.valueOf(3600), Integer.valueOf(7200), new IpRange("192.168.15.2", "192.168.15.99")));
        Assert.assertEquals((Object)result.getConfiguration().getFeatures().getFirewallService(), null);
        Assert.assertEquals((Object)result.getConfiguration().getFeatures().getNatService(), null);
        Assert.assertEquals((Object)result.getNetworkPool(), null);
        Assert.assertEquals((Set)result.getAllowedExternalIpAddresses(), (Set)ImmutableSet.of());
    }

    public void testBridged() {
        InputStream is = this.getClass().getResourceAsStream("/orgnetwork-bridged.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        OrgNetwork result = (OrgNetwork)factory.create((ParseSax.HandlerWithResult)injector.getInstance(OrgNetworkHandler.class)).parse(is);
        Assert.assertEquals((String)result.getName(), (String)"internet01");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/network/758634723"));
        Assert.assertEquals((String)result.getType(), (String)"application/vnd.vmware.vcloud.network+xml");
        Assert.assertEquals((Object)result.getOrg(), (Object)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.org+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/org/9566014")));
        Assert.assertEquals((String)result.getDescription(), null);
        Assert.assertEquals((Collection)result.getTasks(), (Collection)ImmutableList.of());
        assert (result.getConfiguration() != null);
        Assert.assertEquals((Object)result.getConfiguration().getIpScope(), (Object)new IpScope(true, "174.47.101.161", "255.255.255.224", "24.172.173.113", null, null, (Iterable)ImmutableSet.of((Object)new IpRange("174.47.101.164", "174.47.101.190")), (Iterable)ImmutableSet.of()));
        Assert.assertEquals((Object)result.getConfiguration().getParentNetwork(), null);
        Assert.assertEquals((Object)result.getConfiguration().getFenceMode(), (Object)FenceMode.BRIDGED);
        assert (result.getConfiguration().getFeatures() == null);
        Assert.assertEquals((Object)result.getNetworkPool(), null);
        Assert.assertEquals((Set)result.getAllowedExternalIpAddresses(), (Set)ImmutableSet.of());
    }
}

