/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.VAppTemplate;
import org.jclouds.vcloud.domain.Vm;
import org.jclouds.vcloud.domain.internal.VAppTemplateImpl;
import org.jclouds.vcloud.domain.ovf.VCloudNetworkSection;
import org.jclouds.vcloud.util.Utils;
import org.jclouds.vcloud.xml.TaskHandler;
import org.jclouds.vcloud.xml.VmHandler;
import org.jclouds.vcloud.xml.ovf.VCloudNetworkSectionHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VAppTemplateHandler
extends ParseSax.HandlerWithResult<VAppTemplate> {
    protected final TaskHandler taskHandler;
    protected final VmHandler vmHandler;
    protected final VCloudNetworkSectionHandler networkSectionHandler;
    protected StringBuilder currentText = new StringBuilder();
    protected ReferenceType template;
    protected Status status;
    protected ReferenceType vdc;
    protected String description;
    protected List<Task> tasks = Lists.newArrayList();
    protected boolean ovfDescriptorUploaded = true;
    protected String vAppScopedLocalId;
    private boolean inChildren;
    private boolean inTasks;
    private boolean inNetworkSection;
    protected Set<Vm> children = Sets.newLinkedHashSet();
    private VCloudNetworkSection networkSection;

    @Inject
    public VAppTemplateHandler(TaskHandler taskHandler, VmHandler vmHandler, VCloudNetworkSectionHandler networkSectionHandler) {
        this.taskHandler = taskHandler;
        this.vmHandler = vmHandler;
        this.networkSectionHandler = networkSectionHandler;
    }

    public VAppTemplate getResult() {
        return new VAppTemplateImpl(this.template.getName(), this.template.getType(), this.template.getHref(), this.status, this.vdc, this.description, this.tasks, this.ovfDescriptorUploaded, this.vAppScopedLocalId, this.children, this.networkSection);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"Children")) {
            this.inChildren = true;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Tasks")) {
            this.inTasks = true;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"NetworkSection")) {
            this.inNetworkSection = true;
        }
        if (this.inChildren) {
            this.vmHandler.startElement(uri, localName, qName, attrs);
        } else if (this.inTasks) {
            this.taskHandler.startElement(uri, localName, qName, attrs);
        } else if (this.inNetworkSection) {
            this.networkSectionHandler.startElement(uri, localName, qName, attrs);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"VAppTemplate")) {
            this.template = Utils.newReferenceType(attributes);
            if (attributes.containsKey("status")) {
                this.status = Status.fromValue(Integer.parseInt((String)attributes.get("status")));
            }
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Link") && "up".equals(attributes.get("rel"))) {
            this.vdc = Utils.newReferenceType(attributes);
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"Children")) {
            this.inChildren = false;
            Vm vm = this.vmHandler.getResult();
            if (vm != null) {
                this.children.add(this.vmHandler.getResult());
            }
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Tasks")) {
            this.inTasks = false;
            this.tasks.add(this.taskHandler.getResult());
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"NetworkSection")) {
            this.inNetworkSection = false;
            this.networkSection = this.networkSectionHandler.getResult();
        }
        if (this.inChildren) {
            this.vmHandler.endElement(uri, name, qName);
        } else if (this.inTasks) {
            this.taskHandler.endElement(uri, name, qName);
        } else if (this.inNetworkSection) {
            this.networkSectionHandler.endElement(uri, name, qName);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"Description")) {
            this.description = this.currentOrNull();
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"VAppScopedLocalId")) {
            this.vAppScopedLocalId = this.currentOrNull();
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ovfDescriptorUploaded")) {
            this.ovfDescriptorUploaded = Boolean.parseBoolean(this.currentOrNull());
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inTasks) {
            this.taskHandler.characters(ch, start, length);
        } else if (this.inChildren) {
            this.vmHandler.characters(ch, start, length);
        } else if (this.inNetworkSection) {
            this.networkSectionHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }
}

