/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.internal.OrgImpl;
import org.jclouds.vcloud.util.Utils;
import org.jclouds.vcloud.xml.TaskHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OrgHandler
extends ParseSax.HandlerWithResult<Org> {
    protected final TaskHandler taskHandler;
    private StringBuilder currentText = new StringBuilder();
    protected ReferenceType org;
    protected Map<String, ReferenceType> vdcs = Maps.newLinkedHashMap();
    protected ReferenceType tasksList;
    protected Map<String, ReferenceType> catalogs = Maps.newLinkedHashMap();
    protected Map<String, ReferenceType> networks = Maps.newLinkedHashMap();
    protected List<Task> tasks = Lists.newArrayList();
    protected String description;
    protected String fullName;

    @Inject
    public OrgHandler(TaskHandler taskHandler) {
        this.taskHandler = taskHandler;
    }

    public Org getResult() {
        return new OrgImpl(this.org.getName(), this.org.getType(), this.org.getHref(), this.fullName != null ? this.fullName : this.org.getName(), this.description, this.catalogs, this.vdcs, this.networks, this.tasksList, this.tasks);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map attributes = SaxUtils.cleanseAttributes((Attributes)attrs);
        if (qName.endsWith("Org")) {
            this.org = Utils.newReferenceType(attributes);
        } else if (qName.endsWith("Link")) {
            String type = (String)attributes.get("type");
            if (type != null) {
                if (type.indexOf("vdc+xml") != -1) {
                    Utils.putReferenceType(this.vdcs, attributes);
                } else if (type.indexOf("catalog+xml") != -1) {
                    Utils.putReferenceType(this.catalogs, attributes);
                } else if (type.indexOf("tasksList+xml") != -1) {
                    this.tasksList = Utils.newReferenceType(attributes);
                } else if (type.indexOf("network+xml") != -1) {
                    Utils.putReferenceType(this.networks, attributes);
                }
            }
        } else {
            this.taskHandler.startElement(uri, localName, qName, attrs);
        }
    }

    public void endElement(String uri, String name, String qName) {
        this.taskHandler.endElement(uri, name, qName);
        if (qName.endsWith("Task")) {
            this.tasks.add(this.taskHandler.getResult());
        } else if (qName.endsWith("Description")) {
            this.description = this.currentOrNull();
        } else if (qName.endsWith("FullName")) {
            this.fullName = this.currentOrNull();
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }
}

