/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.VCloudAsyncClient;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.network.OrgNetwork;

@Singleton
public class NetworksInOrg
implements Function<Org, Iterable<OrgNetwork>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final VCloudAsyncClient aclient;
    private final ListeningExecutorService userExecutor;

    @Inject
    NetworksInOrg(VCloudAsyncClient aclient, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.aclient = aclient;
        this.userExecutor = userExecutor;
    }

    public Iterable<OrgNetwork> apply(Org org) {
        return FutureIterables.transformParallel(org.getNetworks().values(), (Function)new Function<ReferenceType, ListenableFuture<? extends OrgNetwork>>(){

            public ListenableFuture<? extends OrgNetwork> apply(ReferenceType from) {
                return NetworksInOrg.this.aclient.getNetworkClient().getNetwork(from.getHref());
            }
        }, (ListeningExecutorService)this.userExecutor, null, (Logger)this.logger, (String)("OrgNetworks in org " + org.getName()));
    }
}

