/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.jclouds.date.DateService;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.ovf.Network;
import org.jclouds.vcloud.domain.GuestCustomizationSection;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.TaskStatus;
import org.jclouds.vcloud.domain.VAppTemplate;
import org.jclouds.vcloud.domain.Vm;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.domain.internal.TaskImpl;
import org.jclouds.vcloud.domain.ovf.VCloudNetworkSection;
import org.jclouds.vcloud.xml.VAppTemplateHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class VAppTemplateHandlerTest {
    public void testUbuntuTemplate() {
        VAppTemplate result = VAppTemplateHandlerTest.parseTemplate();
        Assert.assertEquals((String)result.getName(), (String)"Ubuntu Template");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/vappTemplate-1201908921"));
        Assert.assertEquals((String)result.getType(), (String)"application/vnd.vmware.vcloud.vAppTemplate+xml");
        Assert.assertEquals((Object)result.getStatus(), (Object)Status.OFF);
        Assert.assertEquals((Object)result.getVDC(), (Object)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/vdc/1014839439")));
        Assert.assertEquals((String)result.getDescription(), null);
        Assert.assertEquals((Collection)result.getTasks(), (Collection)ImmutableList.of());
        Assert.assertEquals((String)result.getVAppScopedLocalId(), null);
        assert (result.isOvfDescriptorUploaded());
        Vm vm = (Vm)Iterables.getOnlyElement((Iterable)result.getChildren());
        Assert.assertEquals((String)vm.getName(), (String)"Ubuntu1004");
        Assert.assertEquals((Object)vm.getHref(), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/vm-172837194"));
        Assert.assertEquals((String)vm.getType(), (String)"application/vnd.vmware.vcloud.vAppTemplate+xml");
        Assert.assertEquals((Object)vm.getStatus(), null);
        Assert.assertEquals((Object)vm.getParent(), (Object)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/vappTemplate-1201908921")));
        Assert.assertEquals((String)vm.getDescription(), null);
        Assert.assertEquals((Collection)vm.getTasks(), (Collection)ImmutableList.of());
        Assert.assertEquals((String)vm.getVAppScopedLocalId(), (String)"02_ubuntu_template");
        GuestCustomizationSection guestC = vm.getGuestCustomizationSection();
        Assert.assertEquals((String)guestC.getType(), (String)"application/vnd.vmware.vcloud.guestCustomizationSection+xml");
        Assert.assertEquals((Object)guestC.getHref(), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/vm-172837194/guestCustomizationSection/"));
        Assert.assertEquals((String)guestC.getInfo(), (String)"Specifies Guest OS Customization Settings");
        Assert.assertEquals((Object)guestC.isEnabled(), (Object)Boolean.TRUE);
        Assert.assertEquals((Object)guestC.shouldChangeSid(), (Object)Boolean.FALSE);
        Assert.assertEquals((String)guestC.getVirtualMachineId(), (String)"172837194");
        Assert.assertEquals((Object)guestC.isJoinDomainEnabled(), (Object)Boolean.FALSE);
        Assert.assertEquals((Object)guestC.useOrgSettings(), (Object)Boolean.FALSE);
        Assert.assertEquals((String)guestC.getDomainName(), null);
        Assert.assertEquals((String)guestC.getDomainUserName(), null);
        Assert.assertEquals((String)guestC.getDomainUserPassword(), null);
        Assert.assertEquals((Object)guestC.isAdminPasswordEnabled(), (Object)Boolean.TRUE);
        Assert.assertEquals((Object)guestC.isAdminPasswordAuto(), (Object)Boolean.TRUE);
        Assert.assertEquals((String)guestC.getAdminPassword(), (String)"%3eD%gmF");
        Assert.assertEquals((Object)guestC.isResetPasswordRequired(), (Object)Boolean.FALSE);
        Assert.assertEquals((String)guestC.getCustomizationScript(), (String)"#!/bin/bash if [ \"$1\" = \"postcustomization\" ]; then echo \"post customization\" touch /root/.postcustomization sleep 30 #regenerate keys /bin/rm /etc/ssh/ssh_host_* /usr/sbin/dpkg-reconfigure openssh-server echo \"completed\" fi");
        Assert.assertEquals((String)guestC.getComputerName(), (String)"Ubuntu1004");
        Assert.assertEquals((Object)guestC.getEdit(), null);
        VCloudNetworkSection network = result.getNetworkSection();
        Assert.assertEquals((Object)network.getHref(), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/vappTemplate-1201908921/networkSection/"));
        Assert.assertEquals((String)network.getType(), (String)"application/vnd.vmware.vcloud.networkSection+xml");
        Assert.assertEquals((String)network.getInfo(), (String)"The list of logical networks");
        Assert.assertEquals((Set)network.getNetworks(), (Set)ImmutableSet.of((Object)new Network("vAppNet-vApp Internal", null)));
    }

    public static VAppTemplate parseTemplate() {
        InputStream is = VAppTemplateHandlerTest.class.getResourceAsStream("/vAppTemplate.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        VAppTemplate result = (VAppTemplate)factory.create((ParseSax.HandlerWithResult)injector.getInstance(VAppTemplateHandler.class)).parse(is);
        return result;
    }

    public void testCopyingTemplate() {
        InputStream is = this.getClass().getResourceAsStream("/vAppTemplate-copying.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        DateService dateService = (DateService)injector.getInstance(DateService.class);
        VAppTemplate result = (VAppTemplate)factory.create((ParseSax.HandlerWithResult)injector.getInstance(VAppTemplateHandler.class)).parse(is);
        Assert.assertEquals((String)result.getName(), (String)"Ubuntu10.04_v2");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/vappTemplate-699683881"));
        Assert.assertEquals((String)result.getType(), (String)"application/vnd.vmware.vcloud.vAppTemplate+xml");
        Assert.assertEquals((Object)result.getStatus(), (Object)Status.UNRESOLVED);
        Assert.assertEquals((Object)result.getVDC(), (Object)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/vdc/105186609")));
        Assert.assertEquals((String)result.getDescription(), null);
        Assert.assertEquals((Collection)result.getTasks(), (Collection)ImmutableList.of((Object)new TaskImpl(URI.create("https://vcenterprise.bluelock.com/api/v1.0/task/q62gxhi32xgd9yrqvr"), "Copying Virtual Application Template Ubuntu10.04_v2(699683881)", TaskStatus.RUNNING, dateService.iso8601DateParse("2010-09-17T23:20:46.039-04:00"), dateService.iso8601DateParse("9999-12-31T23:59:59.999-05:00"), dateService.iso8601DateParse("2010-12-16T23:20:46.039-05:00"), (ReferenceType)new ReferenceTypeImpl("Ubuntu10.04_v2", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/vappTemplate-699683881")), null)));
        Assert.assertEquals((String)result.getVAppScopedLocalId(), null);
        assert (result.isOvfDescriptorUploaded());
        Assert.assertEquals((Collection)result.getChildren(), (Collection)ImmutableList.of());
        Assert.assertEquals((Object)result.getNetworkSection(), null);
    }

    public void testVAppTemplateWithNewlinesAndNamespacedElements() {
        InputStream is = this.getClass().getResourceAsStream("/vAppTemplate1.0-vcd15_withNewlines.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        factory.create((ParseSax.HandlerWithResult)injector.getInstance(VAppTemplateHandler.class)).parse(is);
    }
}

