/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.filters;

import com.google.common.base.Supplier;
import org.jclouds.http.HttpRequest;
import org.jclouds.vcloud.filters.AddVCloudAuthorizationAndCookieToRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(testName="AddVCloudAuthorizationAndCookieToRequestTest")
public class AddVCloudAuthorizationAndCookieToRequestTest {
    private AddVCloudAuthorizationAndCookieToRequest filter;

    @BeforeTest
    void setUp() {
        this.filter = new AddVCloudAuthorizationAndCookieToRequest((Supplier)new Supplier<String>(){

            public String get() {
                return "token";
            }
        });
    }

    @Test
    public void testApply() {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://localhost").build();
        request = this.filter.filter(request);
        Assert.assertEquals((int)request.getHeaders().size(), (int)2);
        Assert.assertEquals((String)request.getFirstHeaderOrNull("Cookie"), (String)"vcloud-token=token");
        Assert.assertEquals((String)request.getFirstHeaderOrNull("x-vcloud-authorization"), (String)"token");
    }
}

