/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudloadbalancers.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class ConnectionThrottle {
    private final int maxConnections;
    private final int minConnections;
    private final int maxConnectionRate;
    private final int rateInterval;

    @ConstructorProperties(value={"maxConnections", "minConnections", "maxConnectionRate", "rateInterval"})
    protected ConnectionThrottle(Integer maxConnections, Integer minConnections, Integer maxConnectionRate, Integer rateInterval) {
        this.maxConnections = maxConnections;
        this.minConnections = minConnections;
        this.maxConnectionRate = maxConnectionRate;
        this.rateInterval = rateInterval;
        Preconditions.checkArgument((boolean)this.isValid(), (Object)"At least one of maxConnections, minConnections, maxConnectionRate, or rateInterval must be set.");
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    public int getMaxConnectionRate() {
        return this.maxConnectionRate;
    }

    public int getRateInterval() {
        return this.rateInterval;
    }

    public boolean isValid() {
        return this.maxConnections != 0 && this.minConnections != 0 && this.maxConnectionRate != 0 && this.rateInterval != 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.maxConnections, this.minConnections, this.maxConnectionRate, this.rateInterval});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionThrottle that = (ConnectionThrottle)ConnectionThrottle.class.cast(obj);
        return Objects.equal((Object)this.maxConnections, (Object)that.maxConnections) && Objects.equal((Object)this.minConnections, (Object)that.minConnections) && Objects.equal((Object)this.maxConnectionRate, (Object)that.maxConnectionRate) && Objects.equal((Object)this.rateInterval, (Object)that.rateInterval);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("maxConnections", this.maxConnections).add("minConnections", this.minConnections).add("maxConnectionRate", this.maxConnectionRate).add("rateInterval", this.rateInterval);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().from(this);
    }

    public static class Builder {
        private int maxConnections;
        private int minConnections;
        private int maxConnectionRate;
        private int rateInterval;

        public Builder maxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder minConnections(int minConnections) {
            this.minConnections = minConnections;
            return this;
        }

        public Builder maxConnectionRate(int maxConnectionRate) {
            this.maxConnectionRate = maxConnectionRate;
            return this;
        }

        public Builder rateInterval(int rateInterval) {
            this.rateInterval = rateInterval;
            return this;
        }

        public ConnectionThrottle build() {
            return new ConnectionThrottle(this.maxConnections, this.minConnections, this.maxConnectionRate, this.rateInterval);
        }

        public Builder from(ConnectionThrottle in) {
            return this.maxConnections(in.getMaxConnections()).minConnections(in.getMinConnections()).maxConnectionRate(in.getMaxConnectionRate()).rateInterval(in.getRateInterval());
        }
    }
}

