/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import org.jclouds.javax.annotation.Nullable;

public class MediaType {
    private final String base;
    private final String type;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromMediaType(this);
    }

    @ConstructorProperties(value={"base", "type"})
    protected MediaType(@Nullable String base, @Nullable String type) {
        this.base = base;
        this.type = type;
    }

    @Nullable
    public String getBase() {
        return this.base;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.base, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MediaType that = (MediaType)MediaType.class.cast(obj);
        return Objects.equal((Object)this.base, (Object)that.base) && Objects.equal((Object)this.type, (Object)that.type);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("base", (Object)this.base).add("type", (Object)this.type);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String base;
        protected String type;

        protected abstract T self();

        public T base(String base) {
            this.base = base;
            return this.self();
        }

        public T type(String type) {
            this.type = type;
            return this.self();
        }

        public MediaType build() {
            return new MediaType(this.base, this.type);
        }

        public T fromMediaType(MediaType in) {
            return ((Builder)this.base(in.getBase())).type(in.getType());
        }
    }
}

