/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.domain;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import org.jclouds.glacier.domain.InventoryRetrievalParameters;
import org.jclouds.glacier.domain.JobRequest;
import org.jclouds.javax.annotation.Nullable;

public class InventoryRetrievalJobRequest
extends JobRequest {
    private static final String TYPE = "inventory-retrieval";
    @SerializedName(value="Description")
    private final String description;
    @SerializedName(value="Format")
    private final String format;
    @SerializedName(value="InventoryRetrievalParameters")
    private final InventoryRetrievalParameters parameters;

    @ConstructorProperties(value={"Description", "Format"})
    private InventoryRetrievalJobRequest(@Nullable String description, @Nullable String format) {
        super(TYPE);
        this.description = description;
        this.format = format;
        this.parameters = new InventoryRetrievalParameters();
    }

    public String getDescription() {
        return this.description;
    }

    public String getFormat() {
        return this.format;
    }

    public InventoryRetrievalParameters getParameters() {
        return this.parameters;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.description, this.format, this.parameters});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InventoryRetrievalJobRequest other = (InventoryRetrievalJobRequest)obj;
        return Objects.equal((Object)this.description, (Object)other.description) && Objects.equal((Object)this.format, (Object)other.format) && Objects.equal((Object)this.parameters, (Object)other.parameters);
    }

    public String toString() {
        return "InventoryRetrievalJobRequest [description=" + this.description + ", format=" + this.format + ",parameters=" + this.parameters + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String description;
        private String format;
        private String startDate;
        private String endDate;
        private Integer limit;
        private String marker;

        Builder() {
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public InventoryRetrievalJobRequest build() {
            InventoryRetrievalJobRequest request = new InventoryRetrievalJobRequest(this.description, this.format);
            request.getParameters().setEndDate(this.endDate);
            request.getParameters().setStartDate(this.startDate);
            request.getParameters().setLimit(this.limit);
            request.getParameters().setMarker(this.marker);
            return request;
        }
    }
}

