/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.xml;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.cloudwatch.domain.Datapoint;
import org.jclouds.cloudwatch.domain.GetMetricStatisticsResponse;
import org.jclouds.cloudwatch.xml.DatapointHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GetMetricStatisticsResponseHandlerV2
extends ParseSax.HandlerWithResult<GetMetricStatisticsResponse> {
    private StringBuilder currentText = new StringBuilder();
    private Set<Datapoint> datapoints = Sets.newLinkedHashSet();
    private String label;
    private final DatapointHandler datapointHandler;
    private boolean inDatapoints;

    @Inject
    public GetMetricStatisticsResponseHandlerV2(DatapointHandler datapointHandler) {
        this.datapointHandler = datapointHandler;
    }

    public GetMetricStatisticsResponse getResult() {
        return new GetMetricStatisticsResponse(this.datapoints, this.label);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("Datapoints")) {
            this.inDatapoints = true;
        }
        if (this.inDatapoints) {
            this.datapointHandler.startElement(uri, localName, qName, attributes);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.inDatapoints) {
            if (qName.equals("Datapoints")) {
                this.inDatapoints = false;
            } else {
                this.datapointHandler.endElement(uri, localName, qName);
                if (qName.equals("member")) {
                    this.datapoints.add(this.datapointHandler.getResult());
                }
            }
        } else if (qName.equals("Label")) {
            this.label = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inDatapoints) {
            this.datapointHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

