/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jclouds.domain.JsonBall;
import org.jclouds.ohai.Automatic;

public class ChefUtils {
    public static Date fromOhaiTime(JsonBall ohaiDate) {
        return new Date(Long.parseLong(((JsonBall)Preconditions.checkNotNull((Object)ohaiDate, (Object)"ohaiDate")).toString().replaceAll("\\.[0-9]*$", "")));
    }

    public static JsonBall toOhaiTime(long millis) {
        return new JsonBall(millis + "");
    }

    public static MapBinder<String, Supplier<JsonBall>> ohaiAutomaticAttributeBinder(Binder binder) {
        MapBinder mapbinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<String>(){}, (TypeLiteral)new TypeLiteral<Supplier<JsonBall>>(){}, Automatic.class);
        return mapbinder;
    }

    public static String findRoleInRunList(List<String> runList) {
        final Pattern pattern = Pattern.compile("^role\\[(.*)\\]$");
        String roleToParse = (String)Iterables.find(runList, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return pattern.matcher(input).matches();
            }
        });
        Matcher matcher = pattern.matcher(roleToParse);
        matcher.find();
        return matcher.group(1);
    }
}

