/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.Client;
import org.jclouds.chef.strategy.ListClients;
import org.jclouds.logging.Logger;

@Singleton
public class ListClientsImpl
implements ListClients {
    protected final ChefApi api;
    @Resource
    @Named(value="jclouds.chef")
    protected Logger logger = Logger.NULL;

    @Inject
    ListClientsImpl(ChefApi api) {
        this.api = (ChefApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    @Override
    public Iterable<? extends Client> execute() {
        Set<String> toGet = this.api.listClients();
        Iterable clients = Iterables.transform(toGet, (Function)new Function<String, Client>(){

            public Client apply(String input) {
                return ListClientsImpl.this.api.getClient(input);
            }
        });
        this.logger.trace(String.format("getting clients: %s", Joiner.on((char)',').join(toGet)), new Object[0]);
        return clients;
    }

    @Override
    public Iterable<? extends Client> execute(ExecutorService executorService) {
        return this.execute(MoreExecutors.listeningDecorator((ExecutorService)executorService));
    }

    private Iterable<? extends Client> execute(ListeningExecutorService listeningExecutor) {
        return this.executeConcurrently(listeningExecutor, this.api.listClients());
    }

    private Iterable<? extends Client> executeConcurrently(final ListeningExecutorService executor, Iterable<String> toGet) {
        ListenableFuture futures = Futures.allAsList((Iterable)Iterables.transform(toGet, (Function)new Function<String, ListenableFuture<Client>>(){

            public ListenableFuture<Client> apply(final String input) {
                return executor.submit((Callable)new Callable<Client>(){

                    @Override
                    public Client call() throws Exception {
                        return ListClientsImpl.this.api.getClient(input);
                    }
                });
            }
        }));
        this.logger.trace(String.format("getting clients: %s", Joiner.on((char)',').join(toGet)), new Object[0]);
        return (Iterable)Futures.getUnchecked((Future)futures);
    }
}

