/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.mailbox;

import java.util.concurrent.Callable;
import org.apache.james.cli.mailbox.MailboxCommand;
import org.apache.james.webadmin.httpclient.feign.JamesFeignException;
import picocli.CommandLine;

@CommandLine.Command(name="create", description={"Create a new mailbox"})
public class MailboxCreateCommand
implements Callable<Integer> {
    @CommandLine.ParentCommand
    MailboxCommand mailboxCommand;
    @CommandLine.Parameters(description={"Username"})
    String userName;
    @CommandLine.Parameters(description={"Mailbox's name to be created"})
    String mailboxName;

    @Override
    public Integer call() {
        try {
            this.mailboxCommand.fullyQualifiedURL("/users").createAMailbox(this.userName, this.mailboxName);
            this.mailboxCommand.out.println("The mailbox was created successfully.");
            return 0;
        }
        catch (Exception e) {
            if (e instanceof JamesFeignException) {
                this.mailboxCommand.err.println(e.getMessage());
            } else {
                e.printStackTrace(this.mailboxCommand.err);
            }
            return 1;
        }
    }
}

