/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mock.smtp.server.model;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import jakarta.mail.internet.AddressException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.james.core.MailAddress;

@JsonDeserialize(builder=Builder.class)
public class Mail {
    @JsonUnwrapped
    private final Envelope envelope;
    private final String message;

    public Mail(Envelope envelope, String message) {
        Preconditions.checkNotNull((Object)envelope);
        Preconditions.checkNotNull((Object)message);
        this.envelope = envelope;
        this.message = message;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public String getMessage() {
        return this.message;
    }

    public final boolean equals(Object o) {
        if (o instanceof Mail) {
            Mail mail = (Mail)o;
            return Objects.equals(this.envelope, mail.envelope) && Objects.equals(this.message, mail.message);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.envelope, this.message);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("envelope", (Object)this.envelope).add("message", (Object)this.message).toString();
    }

    @JsonDeserialize(builder=Builder.class)
    public static class Envelope {
        private final MailAddress from;
        private final Set<Recipient> recipients;
        private final Set<Parameter> mailParameters;

        public static Builder builder() {
            return new Builder();
        }

        public static Envelope ofAddresses(MailAddress from, MailAddress ... recipients) {
            return new Envelope(from, (Set)Stream.of(recipients).map(Recipient::of).collect(ImmutableSet.toImmutableSet()), Set.of());
        }

        public static Envelope of(MailAddress from, Recipient ... recipients) {
            return new Envelope(from, (Set<Recipient>)ImmutableSet.copyOf(Arrays.asList(recipients)), Set.of());
        }

        private Envelope(MailAddress from, Set<Recipient> recipients, Set<Parameter> mailParameters) {
            this.mailParameters = mailParameters;
            Preconditions.checkNotNull((Object)from);
            Preconditions.checkNotNull(recipients);
            Preconditions.checkArgument((!recipients.isEmpty() ? 1 : 0) != 0, (Object)"'recipients' field should not be empty");
            this.from = from;
            this.recipients = recipients;
        }

        public MailAddress getFrom() {
            return this.from;
        }

        public Set<Recipient> getRecipients() {
            return this.recipients;
        }

        public Set<Parameter> getMailParameters() {
            return this.mailParameters;
        }

        public final boolean equals(Object o) {
            if (o instanceof Envelope) {
                Envelope envelope = (Envelope)o;
                return Objects.equals(this.from, envelope.from) && Objects.equals(this.recipients, envelope.recipients) && Objects.equals(this.mailParameters, envelope.mailParameters);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.from, this.recipients, this.mailParameters);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("from", (Object)this.from).add("recipients", this.recipients).add("mailParameters", this.mailParameters).toString();
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class Builder {
            private MailAddress from;
            private ImmutableSet.Builder<Recipient> recipients = new ImmutableSet.Builder();
            private ImmutableSet.Builder<Parameter> mailParameters = new ImmutableSet.Builder();

            public Builder from(MailAddress from) {
                this.from = from;
                return this;
            }

            public Builder from(String from) {
                if (from.equals("<>")) {
                    this.from = MailAddress.nullSender();
                } else {
                    try {
                        this.from = new MailAddress(from);
                    }
                    catch (AddressException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this;
            }

            public Builder addRecipientMailAddress(MailAddress mailAddress) {
                this.recipients.add((Object)Recipient.of(mailAddress));
                return this;
            }

            public Builder addMailParameter(Parameter parameter) {
                this.mailParameters.add((Object)parameter);
                return this;
            }

            public Builder mailParameters(Collection<Parameter> parameters) {
                this.mailParameters.addAll(parameters);
                return this;
            }

            public Builder addRecipient(Recipient recipient) {
                this.recipients.add((Object)recipient);
                return this;
            }

            public Builder recipients(List<Recipient> recipients) {
                this.recipients.addAll(recipients);
                return this;
            }

            public Envelope build() {
                return new Envelope(this.from, (Set<Recipient>)this.recipients.build(), (Set<Parameter>)this.mailParameters.build());
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonUnwrapped
        private Envelope envelope;
        private String message;

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder envelope(Envelope envelope) {
            this.envelope = envelope;
            return this;
        }

        public Mail build() {
            return new Mail(this.envelope, this.message);
        }
    }

    @JsonDeserialize(builder=Builder.class)
    public static class Recipient {
        private final MailAddress address;
        private final List<Parameter> parameters;

        public static Builder builder() {
            return new Builder();
        }

        public static Recipient of(MailAddress address) {
            return new Recipient(address, List.of());
        }

        private Recipient(MailAddress address, List<Parameter> parameters) {
            this.address = address;
            this.parameters = parameters;
        }

        public MailAddress getAddress() {
            return this.address;
        }

        public List<Parameter> getParameters() {
            return this.parameters;
        }

        public final boolean equals(Object o) {
            if (o instanceof Recipient) {
                Recipient that = (Recipient)o;
                return Objects.equals(this.address, that.address) && Objects.equals(this.parameters, that.parameters);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.address, this.parameters);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("address", (Object)this.address).add("parameters", this.parameters).toString();
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class Builder {
            private MailAddress address;
            private ImmutableList.Builder<Parameter> parameters = new ImmutableList.Builder();

            public Builder address(MailAddress address) {
                this.address = address;
                return this;
            }

            public Builder addParameter(Parameter parameter) {
                this.parameters.add((Object)parameter);
                return this;
            }

            public Builder parameters(Collection<Parameter> parameters) {
                this.parameters.addAll(parameters);
                return this;
            }

            public Recipient build() {
                Preconditions.checkState((this.address != null ? 1 : 0) != 0, (Object)"'address' field cannot be omitted");
                return new Recipient(this.address, (List<Parameter>)this.parameters.build());
            }
        }
    }

    @JsonDeserialize(builder=Builder.class)
    public static class Parameter {
        private final String name;
        private final String value;

        public static Builder builder() {
            return new Builder();
        }

        public static Collection<Parameter> fromArgLine(String argLine) {
            return (Collection)Splitter.on((char)' ').splitToStream((CharSequence)argLine).filter(argString -> !argString.contains(":")).map(Parameter::fromString).collect(ImmutableList.toImmutableList());
        }

        public static Parameter fromString(String argString) {
            if (!argString.contains("=")) {
                return Parameter.builder().name(argString).build();
            }
            Preconditions.checkArgument((boolean)argString.contains("="));
            int index = argString.indexOf(61);
            return Parameter.builder().name(argString.substring(0, index)).value(argString.substring(index + 1)).build();
        }

        private Parameter(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public final boolean equals(Object o) {
            if (o instanceof Parameter) {
                Parameter that = (Parameter)o;
                return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.name, this.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("value", (Object)this.value).toString();
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class Builder {
            private String name;
            private Optional<String> value = Optional.empty();

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = Optional.ofNullable(value);
                return this;
            }

            public Parameter build() {
                Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"'name' field cannot be omitted");
                return new Parameter(this.name, this.value.orElse(""));
            }
        }
    }
}

