/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mock.smtp.server;

import org.apache.james.mock.smtp.server.HTTPConfigurationServer;
import org.apache.james.mock.smtp.server.MockSMTPServer;
import org.apache.james.mock.smtp.server.ReceivedMailRepository;
import org.apache.james.mock.smtp.server.SMTPBehaviorRepository;
import org.apache.james.util.Port;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockSMTPServerMain {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockSMTPServerMain.class);
    private static final Port HTTP_PORT = new Port(8000);
    private static final Port SMTP_PORT = new Port(25);

    public static void main(String[] args) {
        SMTPBehaviorRepository behaviorRepository = new SMTPBehaviorRepository();
        ReceivedMailRepository receivedMailRepository = new ReceivedMailRepository();
        HTTPConfigurationServer httpConfigurationServer = HTTPConfigurationServer.onPort(behaviorRepository, receivedMailRepository, HTTP_PORT);
        MockSMTPServer mockSMTPServer = MockSMTPServer.onPort(behaviorRepository, receivedMailRepository, SMTP_PORT);
        httpConfigurationServer.start();
        mockSMTPServer.start();
        LOGGER.info("Mock SMTP server started");
    }
}

