/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import com.google.common.collect.ImmutableList;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005M4q\u0001D\u0007\u0011\u0002\u0007\u0005!\u0004C\u0003\"\u0001\u0011\u0005!\u0005C\u0003'\u0001\u0019Eq\u0005C\u0003E\u0001\u0019E!\u0005C\u0003F\u0001\u0011\u0005a\tC\u0003Y\u0001\u0011\u0005!\u0005C\u0003^\u0001\u0011\u0005!\u0005C\u0003`\u0001\u0011\u0005\u0001\rC\u0003d\u0001\u0011\u0005A\rC\u0003h\u0001\u0011\u0005\u0001\u000eC\u0003l\u0001\u0011\u0005A\u000eC\u0003p\u0001\u0011\u0005\u0001OA\tUQJ,\u0017\rZ$fi\u000e{g\u000e\u001e:bGRT!AD\b\u0002\u0011\r|g\u000e\u001e:bGRT!\u0001E\t\u0002\u000fI47\r\u000f\u001c3c)\u0011!cE\u0001\u0005U6\f\u0007O\u0003\u0002\u0015+\u0005)!.Y7fg*\u0011acF\u0001\u0007CB\f7\r[3\u000b\u0003a\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g\u0003\u0019!\u0013N\\5uIQ\t1\u0005\u0005\u0002\u001dI%\u0011Q%\b\u0002\u0005+:LG/A\tbo\u0006LG/T3tg\u0006<WmQ8v]R$Ba\t\u0015;\u007f!)\u0011F\u0001a\u0001U\u0005QQ.Y5mE>D\u0018\nZ:\u0011\u0007-\u0002$'D\u0001-\u0015\tic&\u0001\u0003vi&d'\"A\u0018\u0002\t)\fg/Y\u0005\u0003c1\u0012A\u0001T5tiB\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\u0006[>$W\r\u001c\u0006\u0003oM\tq!\\1jY\n|\u00070\u0003\u0002:i\tIQ*Y5mE>D\u0018\n\u001a\u0005\u0006w\t\u0001\r\u0001P\u0001\u0006cV,'/\u001f\t\u0003guJ!A\u0010\u001b\u0003\u0017M+\u0017M]2i#V,'/\u001f\u0005\u0006\u0001\n\u0001\r!Q\u0001\r[\u0016\u001c8/Y4f\u0007>,h\u000e\u001e\t\u00039\tK!aQ\u000f\u0003\t1{gnZ\u0001\u0015S:LGo\u00149f]N+\u0017M]2i\u00072LWM\u001c;\u0002\u000bM,G/\u00169\u0015\u0005\r:\u0005\"\u0002%\u0005\u0001\u0004I\u0015AB:feZ,'\u000f\u0005\u0002K\u00176\t1#\u0003\u0002M'\t\u0001r)^5dK*\u000bW.Z:TKJ4XM\u001d\u0015\u0003\t9\u0003\"a\u0014,\u000e\u0003AS!!\u0015*\u0002\u0007\u0005\u0004\u0018N\u0003\u0002T)\u00069!.\u001e9ji\u0016\u0014(BA+\u0018\u0003\u0015QWO\\5u\u0013\t9\u0006K\u0001\u0006CK\u001a|'/Z#bG\"\f\u0011gZ5wK:tuN\\'fgN\fw-\u001a+iK:<U\r\u001e+ie\u0016\fGm]*i_VdGMU3ukJtgj\u001c;G_VtG\r\u000b\u0002\u00065B\u0011qjW\u0005\u00039B\u0013A\u0001V3ti\u0006a\"-\u00193BG\u000e|WO\u001c;JINCw.\u001e7e\u0005\u0016\u0014VM[3di\u0016$\u0007F\u0001\u0004[\u0003\u0015\fG\r\u001a*fY\u0006$X\rZ'bS2\u001c\u0018J\\!UQJ,\u0017\r\u001a+iK:<U\r\u001e+iCR$\u0006N]3bINCw.\u001e7e%\u0016$XO\u001d8Fq\u0006\u001cG\u000f\u00165sK\u0006$wJ\u00196fGR<\u0016\u000e\u001e5F[\u0006LG.\u00133t'>\u0014H/\u001a3Cs\u0006\u0013(/\u001b<bY\u0012\u000bG/\u001a\u000b\u0003G\u0005DQ\u0001S\u0004A\u0002%C#a\u0002.\u0002;\u001eLg/\u001a8Uo>$\u0006N]3bI\u001e+G\u000f\u00165biR;x\u000e\u00165sK\u0006$7\u000b[8vY\u0012\u0014V\r^;s]\u0016C\u0018m\u0019;Uo>$\u0006N]3bI>\u0013'.Z2u/&$\b.R7bS2LEm]*peR,GMQ=BeJLg/\u00197ECR,GCA\u0012f\u0011\u0015A\u0005\u00021\u0001JQ\tA!,\u0001#hSZ,gn\u00148f)\"\u0014X-\u00193HKR$vo\u001c+ie\u0016\fGm\u00155pk2$'+\u001a;ve:|e\u000e\\=P]\u0016$\u0006N]3bI>\u0013'.Z2u\u0003:$gj\u001c;G_VtG\r\u0006\u0002$S\")\u0001*\u0003a\u0001\u0013\"\u0012\u0011BW\u0001jC\u0012$G\u000b\u001b:fK6\u000b\u0017\u000e\\:XSRD'+\u001a7bi\u0016$7+\u001e2kK\u000e$()\u001e;O_:LE-\u001a8uS\u000e\fG.T5nK6+7o]1hK&#E\u000b[3o\u000f\u0016$H\u000b[1u)\"\u0014X-\u00193TQ>,H\u000e\u001a(piJ+G/\u001e:o+:\u0014X\r\\1uK\u0012l\u0015-\u001b7t)\t\u0019S\u000eC\u0003I\u0015\u0001\u0007\u0011\n\u000b\u0002\u000b5\u0006I\u0017\r\u001a3UQJ,W-T1jYN<\u0016\u000e\u001e5JI\u0016tG/[2bY6KW.Z'fgN\fw-Z%E\u0005V$hj\u001c8SK2\fG/\u001a3Tk\nTWm\u0019;UQ\u0016tw)\u001a;UQ\u0006$H\u000b\u001b:fC\u0012\u001c\u0006n\\;mI:{GOU3ukJtWK\u001c:fY\u0006$X\rZ'bS2\u001cHCA\u0012r\u0011\u0015A5\u00021\u0001JQ\tY!\f")
public interface ThreadGetContract {
    public void awaitMessageCount(List<MailboxId> var1, SearchQuery var2, long var3);

    public void initOpenSearchClient();

    public static /* synthetic */ void setUp$(ThreadGetContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        this.initOpenSearchClient();
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addDomain("domain-alias.tld").addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void givenNonMessageThenGetThreadsShouldReturnNotFound$(ThreadGetContract $this) {
        $this.givenNonMessageThenGetThreadsShouldReturnNotFound();
    }

    @Test
    default public void givenNonMessageThenGetThreadsShouldReturnNotFound() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Thread/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": [\"123456\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\"methodResponses\": [\n           |\t\t[\n           |\t\t\t\"Thread/get\",\n           |\t\t\t{\n           |\t\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |\t\t\t\t\"state\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\t\t\t\"list\": [\n           |\n           |\t\t\t\t],\n           |\t\t\t\t\"notFound\": [\n           |\t\t\t\t\t\"123456\"\n           |\t\t\t\t]\n           |\t\t\t},\n           |\t\t\t\"c1\"\n           |\t\t]\n           |\t]\n           |}")));
    }

    public static /* synthetic */ void badAccountIdShouldBeRejected$(ThreadGetContract $this) {
        $this.badAccountIdShouldBeRejected();
    }

    @Test
    default public void badAccountIdShouldBeRejected() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Thread/get\",\n         |    {\n         |      \"accountId\": \"bad\",\n         |      \"ids\": [\"123456\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n          |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n          |    \"methodResponses\": [\n          |        [\n          |            \"error\",\n          |            {\n          |                \"type\": \"accountNotFound\"\n          |            },\n          |            \"c1\"\n          |        ]\n          |    ]\n          |}")));
    }

    public static /* synthetic */ void addRelatedMailsInAThreadThenGetThatThreadShouldReturnExactThreadObjectWithEmailIdsSortedByArrivalDate$(ThreadGetContract $this, GuiceJamesServer server) {
        $this.addRelatedMailsInAThreadThenGetThatThreadShouldReturnExactThreadObjectWithEmailIdsSortedByArrivalDate(server);
    }

    @Test
    default public void addRelatedMailsInAThreadThenGetThatThreadShouldReturnExactThreadObjectWithEmailIdsSortedByArrivalDate(GuiceJamesServer server) {
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        MessageManager.AppendResult message1 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessageAndGetAppendResult(Fixture$.MODULE$.BOB().asString(), bobPath, MessageManager.AppendCommand.from((Message.Builder)Message.Builder.of().setSubject("Test").setMessageId("Message-ID-1").setBody("testmail", StandardCharsets.UTF_8)));
        this.awaitMessageCount((List<MailboxId>)ImmutableList.of(), SearchQuery.matchAll(), 1L);
        MessageManager.AppendResult message2 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessageAndGetAppendResult(Fixture$.MODULE$.BOB().asString(), bobPath, MessageManager.AppendCommand.from((Message.Builder)Message.Builder.of().setSubject("Re: Test").setMessageId("Message-ID-2").setField((Field)new RawField("In-Reply-To", "Message-ID-1")).setBody("testmail", StandardCharsets.UTF_8)));
        this.awaitMessageCount((List<MailboxId>)ImmutableList.of(), SearchQuery.matchAll(), 2L);
        MessageManager.AppendResult message3 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessageAndGetAppendResult(Fixture$.MODULE$.BOB().asString(), bobPath, MessageManager.AppendCommand.from((Message.Builder)Message.Builder.of().setSubject("Fwd: Re: Test").setMessageId("Message-ID-3").setField((Field)new RawField("In-Reply-To", "Random-InReplyTo")).addField((Field)new RawField("References", "Message-ID-1")).setBody("testmail", StandardCharsets.UTF_8)));
        this.awaitMessageCount((List<MailboxId>)ImmutableList.of(), SearchQuery.matchAll(), 3L);
        String threadId = message1.getThreadId().serialize();
        String message1Id = message1.getId().getMessageId().serialize();
        String message2Id = message2.getId().getMessageId().serialize();
        String message3Id = message3.getId().getMessageId().serialize();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Thread/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": [\"" + threadId + "\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\"methodResponses\": [\n           |\t\t[\n           |\t\t\t\"Thread/get\",\n           |\t\t\t{\n           |\t\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |\t\t\t\t\"state\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\t\t\t\"list\": [{\n           |\t\t\t\t\t\"id\": \"" + threadId + "\",\n           |\t\t\t\t\t\"emailIds\": [\"" + message1Id + "\", \"" + message2Id + "\", \"" + message3Id + "\"]\n           |\t\t\t\t}],\n           |\t\t\t\t\"notFound\": [\n           |\n           |\t\t\t\t]\n           |\t\t\t},\n           |\t\t\t\"c1\"\n           |\t\t]\n           |\t]\n           |}")));
    }

    public static /* synthetic */ void givenTwoThreadGetThatTwoThreadShouldReturnExactTwoThreadObjectWithEmailIdsSortedByArrivalDate$(ThreadGetContract $this, GuiceJamesServer server) {
        $this.givenTwoThreadGetThatTwoThreadShouldReturnExactTwoThreadObjectWithEmailIdsSortedByArrivalDate(server);
    }

    @Test
    default public void givenTwoThreadGetThatTwoThreadShouldReturnExactTwoThreadObjectWithEmailIdsSortedByArrivalDate(GuiceJamesServer server) {
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        MessageManager.AppendResult message1 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessageAndGetAppendResult(Fixture$.MODULE$.BOB().asString(), bobPath, MessageManager.AppendCommand.from((Message.Builder)Message.Builder.of().setSubject("Test").setMessageId("Message-ID-1").setBody("testmail", StandardCharsets.UTF_8)));
        this.awaitMessageCount((List<MailboxId>)ImmutableList.of(), SearchQuery.matchAll(), 1L);
        MessageManager.AppendResult message2 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessageAndGetAppendResult(Fixture$.MODULE$.BOB().asString(), bobPath, MessageManager.AppendCommand.from((Message.Builder)Message.Builder.of().setSubject("Re: Test").setMessageId("Message-ID-2").setField((Field)new RawField("In-Reply-To", "Message-ID-1")).setBody("testmail", StandardCharsets.UTF_8)));
        String threadA = message1.getThreadId().serialize();
        MessageManager.AppendResult message3 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessageAndGetAppendResult(Fixture$.MODULE$.BOB().asString(), bobPath, MessageManager.AppendCommand.from((Message.Builder)Message.Builder.of().setSubject("Message3-SubjectLine").setMessageId("Message-ID-3").setBody("testmail", StandardCharsets.UTF_8)));
        String threadB = message3.getThreadId().serialize();
        this.awaitMessageCount((List<MailboxId>)ImmutableList.of(), SearchQuery.matchAll(), 3L);
        String message1Id = message1.getId().getMessageId().serialize();
        String message2Id = message2.getId().getMessageId().serialize();
        String message3Id = message3.getId().getMessageId().serialize();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Thread/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": [\"" + threadA + "\", \"" + threadB + "\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0][1].list").isArray().contains(new Object[]{"{\"id\":\"" + threadA + "\",\"emailIds\":[\"" + message1Id + "\",\"" + message2Id + "\"]}", "{\"id\":\"" + threadB + "\",\"emailIds\":[\"" + message3Id + "\"]}"});
    }

    public static /* synthetic */ void givenOneThreadGetTwoThreadShouldReturnOnlyOneThreadObjectAndNotFound$(ThreadGetContract $this, GuiceJamesServer server) {
        $this.givenOneThreadGetTwoThreadShouldReturnOnlyOneThreadObjectAndNotFound(server);
    }

    @Test
    default public void givenOneThreadGetTwoThreadShouldReturnOnlyOneThreadObjectAndNotFound(GuiceJamesServer server) {
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        MessageManager.AppendResult message1 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessageAndGetAppendResult(Fixture$.MODULE$.BOB().asString(), bobPath, MessageManager.AppendCommand.from((Message.Builder)Message.Builder.of().setSubject("Test").setMessageId("Message-ID-1").setBody("testmail", StandardCharsets.UTF_8)));
        MessageManager.AppendResult message2 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessageAndGetAppendResult(Fixture$.MODULE$.BOB().asString(), bobPath, MessageManager.AppendCommand.from((Message.Builder)Message.Builder.of().setSubject("Re: Test").setMessageId("Message-ID-2").setField((Field)new RawField("In-Reply-To", "Message-ID-1")).setBody("testmail", StandardCharsets.UTF_8)));
        String threadA = message1.getThreadId().serialize();
        this.awaitMessageCount((List<MailboxId>)ImmutableList.of(), SearchQuery.matchAll(), 2L);
        String message1Id = message1.getId().getMessageId().serialize();
        String message2Id = message2.getId().getMessageId().serialize();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Thread/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": [\"" + threadA + "\", \"nonExistThread\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\"methodResponses\": [\n           |\t\t[\n           |\t\t\t\"Thread/get\",\n           |\t\t\t{\n           |\t\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |\t\t\t\t\"state\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\t\t\t\"list\": [{\n           |\t\t\t\t\t\"id\": \"" + threadA + "\",\n           |\t\t\t\t\t\"emailIds\": [\n           |\t\t\t\t\t\t\"" + message1Id + "\",\n           |\t\t\t\t\t\t\"" + message2Id + "\"\n           |\t\t\t\t\t]\n           |\t\t\t\t}],\n           |\t\t\t\t\"notFound\": [\n           |\t\t\t\t\t\"nonExistThread\"\n           |\t\t\t\t]\n           |\t\t\t},\n           |\t\t\t\"c1\"\n           |\t\t]\n           |\t]\n           |}")));
    }

    public static /* synthetic */ void addThreeMailsWithRelatedSubjectButNonIdenticalMimeMessageIDThenGetThatThreadShouldNotReturnUnrelatedMails$(ThreadGetContract $this, GuiceJamesServer server) {
        $this.addThreeMailsWithRelatedSubjectButNonIdenticalMimeMessageIDThenGetThatThreadShouldNotReturnUnrelatedMails(server);
    }

    @Test
    default public void addThreeMailsWithRelatedSubjectButNonIdenticalMimeMessageIDThenGetThatThreadShouldNotReturnUnrelatedMails(GuiceJamesServer server) {
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        MessageManager.AppendResult message1 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessageAndGetAppendResult(Fixture$.MODULE$.BOB().asString(), bobPath, MessageManager.AppendCommand.from((Message.Builder)Message.Builder.of().setSubject("Test").setMessageId("Message-ID-1").setBody("testmail", StandardCharsets.UTF_8)));
        MessageManager.AppendResult message2 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessageAndGetAppendResult(Fixture$.MODULE$.BOB().asString(), bobPath, MessageManager.AppendCommand.from((Message.Builder)Message.Builder.of().setSubject("Re: Test").setMessageId("Message-ID-2").setField((Field)new RawField("In-Reply-To", "Random-InReplyTo")).setBody("testmail", StandardCharsets.UTF_8)));
        MessageManager.AppendResult message3 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessageAndGetAppendResult(Fixture$.MODULE$.BOB().asString(), bobPath, MessageManager.AppendCommand.from((Message.Builder)Message.Builder.of().setSubject("Fwd: Re: Test").setMessageId("Message-ID-3").setField((Field)new RawField("In-Reply-To", "Another-Random-InReplyTo")).addField((Field)new RawField("References", "Random-References")).setBody("testmail", StandardCharsets.UTF_8)));
        this.awaitMessageCount((List<MailboxId>)ImmutableList.of(), SearchQuery.matchAll(), 3L);
        String threadId1 = message1.getThreadId().serialize();
        String message1Id = message1.getId().getMessageId().serialize();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Thread/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": [\"" + threadId1 + "\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\"methodResponses\": [\n           |\t\t[\n           |\t\t\t\"Thread/get\",\n           |\t\t\t{\n           |\t\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |\t\t\t\t\"state\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\t\t\t\"list\": [{\n           |\t\t\t\t\t\"id\": \"" + threadId1 + "\",\n           |\t\t\t\t\t\"emailIds\": [\"" + message1Id + "\"]\n           |\t\t\t\t}],\n           |\t\t\t\t\"notFound\": [\n           |\n           |\t\t\t\t]\n           |\t\t\t},\n           |\t\t\t\"c1\"\n           |\t\t]\n           |\t]\n           |}")));
    }

    public static /* synthetic */ void addThreeMailsWithIdenticalMimeMessageIDButNonRelatedSubjectThenGetThatThreadShouldNotReturnUnrelatedMails$(ThreadGetContract $this, GuiceJamesServer server) {
        $this.addThreeMailsWithIdenticalMimeMessageIDButNonRelatedSubjectThenGetThatThreadShouldNotReturnUnrelatedMails(server);
    }

    @Test
    default public void addThreeMailsWithIdenticalMimeMessageIDButNonRelatedSubjectThenGetThatThreadShouldNotReturnUnrelatedMails(GuiceJamesServer server) {
        MailboxPath bobPath = MailboxPath.inbox((Username)Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(bobPath);
        MessageManager.AppendResult message1 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessageAndGetAppendResult(Fixture$.MODULE$.BOB().asString(), bobPath, MessageManager.AppendCommand.from((Message.Builder)Message.Builder.of().setSubject("Test1").setMessageId("Message-ID-1").setBody("testmail", StandardCharsets.UTF_8)));
        MessageManager.AppendResult message2 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessageAndGetAppendResult(Fixture$.MODULE$.BOB().asString(), bobPath, MessageManager.AppendCommand.from((Message.Builder)Message.Builder.of().setSubject("Test2").setMessageId("Message-ID-2").setField((Field)new RawField("In-Reply-To", "Message-ID-1")).setBody("testmail", StandardCharsets.UTF_8)));
        MessageManager.AppendResult message3 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessageAndGetAppendResult(Fixture$.MODULE$.BOB().asString(), bobPath, MessageManager.AppendCommand.from((Message.Builder)Message.Builder.of().setSubject("Test3").setMessageId("Message-ID-3").setField((Field)new RawField("In-Reply-To", "Random-InReplyTo")).addField((Field)new RawField("References", "Message-ID-1")).setBody("testmail", StandardCharsets.UTF_8)));
        this.awaitMessageCount((List<MailboxId>)ImmutableList.of(), SearchQuery.matchAll(), 3L);
        String threadId1 = message1.getThreadId().serialize();
        String message1Id = message1.getId().getMessageId().serialize();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Thread/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": [\"" + threadId1 + "\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |\t\"sessionState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\"methodResponses\": [\n           |\t\t[\n           |\t\t\t\"Thread/get\",\n           |\t\t\t{\n           |\t\t\t\t\"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |\t\t\t\t\"state\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a943\",\n           |\t\t\t\t\"list\": [{\n           |\t\t\t\t\t\"id\": \"" + threadId1 + "\",\n           |\t\t\t\t\t\"emailIds\": [\"" + message1Id + "\"]\n           |\t\t\t\t}],\n           |\t\t\t\t\"notFound\": [\n           |\n           |\t\t\t\t]\n           |\t\t\t},\n           |\t\t\t\"c1\"\n           |\t\t]\n           |\t]\n           |}")));
    }

    public static void $init$(ThreadGetContract $this) {
    }
}

