/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.ResponseBodyExtractionOptions;
import io.restassured.response.Validatable;
import io.restassured.response.ValidatableResponse;
import jakarta.mail.internet.SharedInputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.core.Option;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.probe.DelegationProbe;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.modules.ACLProbeImpl;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.util.ClassLoaderUtils;
import org.apache.james.utils.DataProbeImpl;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005caB\f\u0019!\u0003\r\t!\n\u0005\u0006Y\u0001!\t!\f\u0005\tc\u0001A)\u0019!C\u0005e!A1\b\u0001EC\u0002\u0013%A\b\u0003\u0005F\u0001!\u0015\r\u0011\"\u0003=\u0011\u00151\u0005\u0001\"\u0001H\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u0015A\u0007\u0001\"\u0001j\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u0015\u0001\b\u0001\"\u0001r\u0011\u0015!\b\u0001\"\u0001v\u0011\u0015A\b\u0001\"\u0001z\u0011\u0015a\b\u0001\"\u0001~\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007Aq!!\u0003\u0001\t\u0003\tY\u0001C\u0004\u0002\u0012\u0001!\t!a\u0005\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003c\u0001A\u0011AA\u001a\u0011\u001d\tI\u0004\u0001C\u0001\u0003w\u0011adU3be\u000eD7K\\5qa\u0016$x)\u001a;NKRDw\u000eZ\"p]R\u0014\u0018m\u0019;\u000b\u0005eQ\u0012\u0001C2p]R\u0014\u0018m\u0019;\u000b\u0005ma\u0012a\u0002:gGb2$'\r\u0006\u0003;y\tAA[7ba*\u0011q\u0004I\u0001\u0006U\u0006lWm\u001d\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00011\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g-\u0001\u0004%S:LG\u000f\n\u000b\u0002]A\u0011qeL\u0005\u0003a!\u0012A!\u00168ji\u0006)2\u000f\\8x!\u0006\u001cW\r\u001a)pY2Le\u000e^3sm\u0006dW#A\u001a\u0011\u0005QJT\"A\u001b\u000b\u0005Y:\u0014\u0001\u0002;j[\u0016T\u0011\u0001O\u0001\u0005U\u00064\u0018-\u0003\u0002;k\tAA)\u001e:bi&|g.A\u0006dC2lG._!xC&$X#A\u001f\u0011\u0005y\u001aU\"A \u000b\u0005\u0001\u000b\u0015\u0001B2pe\u0016T!A\u0011\u0012\u0002\u0015\u0005<\u0018-\u001b;jY&$\u00180\u0003\u0002E\u007f\t\u00012i\u001c8eSRLwN\u001c$bGR|'/_\u0001\u0016C^\f\u0017\u000e^!u\u001b>\u001cH\u000fV3o'\u0016\u001cwN\u001c3t\u0003\u0015\u0019X\r^+q)\tq\u0003\nC\u0003J\u000b\u0001\u0007!*\u0001\u0004tKJ4XM\u001d\t\u0003\u00172k\u0011AH\u0005\u0003\u001bz\u0011\u0001cR;jG\u0016T\u0015-\\3t'\u0016\u0014h/\u001a:)\u0005\u0015y\u0005C\u0001)X\u001b\u0005\t&B\u0001*T\u0003\r\t\u0007/\u001b\u0006\u0003)V\u000bqA[;qSR,'O\u0003\u0002WE\u0005)!.\u001e8ji&\u0011\u0001,\u0015\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!K:vE*,7\r^*i_VdGMQ3J]N+\u0017M]2i':L\u0007\u000f]3u/\",g.T1uG\",G\r\u0006\u0002/7\")\u0011J\u0002a\u0001\u0015\"\u0012a!\u0018\t\u0003!zK!aX)\u0003\tQ+7\u000f^\u0001*aJ,g/[3x'\"|W\u000f\u001c3CK&s7+Z1sG\"\u001cf.\u001b9qKR<\u0006.\u001a8NCR\u001c\u0007.\u001a3\u0015\u00059\u0012\u0007\"B%\b\u0001\u0004Q\u0005FA\u0004^\u0003)\u001aX-\u0019:dQNs\u0017\u000e\u001d9fi\u001e+Go\u00155pk2$7+\u001e9q_J$()Y2l%\u00164WM]3oG\u0016$\"A\f4\t\u000b%C\u0001\u0019\u0001&)\u0005!i\u0016!N:fCJ\u001c\u0007n\u00158jaB,Go\u00155pk2$\u0017iY2faR\u001c\u0006.\u0019:fI6\u000b\u0017\u000e\u001c2pq\u0016\u001cx\u000b[3o\u000bb$XM\\:j_:$\"A\f6\t\u000b%K\u0001\u0019\u0001&)\u0005%i\u0016aO:fCJ\u001c\u0007n\u00158jaB,Go\u00155pk2$gj\u001c;BG\u000e,\u0007\u000f^*iCJ,G-T1jY\n|\u00070Z:XQ\u0016tgj\u001c;FqR,gn]5p]R\u0011aF\u001c\u0005\u0006\u0013*\u0001\rA\u0013\u0015\u0003\u0015u\u000baf]3be\u000eD7K\\5qa\u0016$8\u000b[8vY\u0012tu\u000e^!dG\u0016\u0004HOT8u'\"\f'/\u001a3NC&d'm\u001c=fgR\u0011aF\u001d\u0005\u0006\u0013.\u0001\rA\u0013\u0015\u0003\u0017u\u000bAg\u001d5pk2$'+\u001a;ve:lU\u000f\u001c;j'\u0016\f'o\u00195T]&\u0004\b/\u001a;J]2K7\u000f^,iK:lU\u000f\u001c;j\u001b\u0006$8\r[3e)\tqc\u000fC\u0003J\u0019\u0001\u0007!\n\u000b\u0002\r;\u0006y2\u000f[8vY\u0012\u001cV\u000f\u001d9peR|%o\u00149fe\u0006$xN]%o\r&dG/\u001a:\u0015\u00059R\b\"B%\u000e\u0001\u0004Q\u0005FA\u0007^\u0003\r\u001a\bn\\;mIJ+G/\u001e:o\u000b6\u0004H/\u001f'jgR<\u0006.\u001a8O_Rl\u0015\r^2iK\u0012$\"A\f@\t\u000b%s\u0001\u0019\u0001&)\u00059i\u0016!L:i_VdGMU3ukJtW*\u0019;dQ\u0016$7+Z1sG\"\u001cf.\u001b9qKR<\u0006.\u001a8EK2,w-\u0019;fIR\u0019a&!\u0002\t\u000b%{\u0001\u0019\u0001&)\u0005=i\u0016\u0001H:i_VdGMR1jY^CWM\\,s_:<\u0017iY2pk:$\u0018\n\u001a\u000b\u0004]\u00055\u0001\"B%\u0011\u0001\u0004Q\u0005F\u0001\t^\u0003U\u001a\bn\\;mIJ+G/\u001e:o\u001d>$hi\\;oI^CWM\\#nC&d\u0017\n\u001a#pKNtu\u000e\u001e\"fY>tw\rV8BG\u000e|WO\u001c;\u0015\u00079\n)\u0002C\u0003J#\u0001\u0007!\n\u000b\u0002\u0012;\u0006\u00013\u000f[8vY\u00124\u0015-\u001b7XQ\u0016tW)\\1jY&#7)\u00198O_R\u0004\u0016M]:f)\rq\u0013Q\u0004\u0005\u0006\u0013J\u0001\rA\u0013\u0015\u0003%u\u000bqf\u001d5pk2$'+\u001a;ve:,U\u000e\u001d;z\u0019&\u001cHo\u00165f]\u0016k\u0017-\u001b7JINLeNU3rk\u0016\u001cH/R7qif$2ALA\u0013\u0011\u0015I5\u00031\u0001KQ\t\u0019R,A\u0019tQ>,H\u000e\u001a*fiV\u0014h.\u00168l]><h.T3uQ>$w\u000b[3o\u001b&\u001c8/\u001b8h\u001f:,7)\u00199bE&d\u0017\u000e^=\u0015\u00079\ni\u0003C\u0003J)\u0001\u0007!\n\u000b\u0002\u0015;\u0006\u00194\u000f[8vY\u0012\u0014V\r^;s]Vs7N\\8x]6+G\u000f[8e/\",g.T5tg&tw-\u00117m\u0007\u0006\u0004\u0018MY5mSRLWm\u001d\u000b\u0004]\u0005U\u0002\"B%\u0016\u0001\u0004Q\u0005FA\u000b^\u0003U\u001a\bn\\;mIJ+G/\u001e:o\u001b\u0006$8\r[5oOJ+7/\u001e7u/\",gnU3be\u000eD7K\\5qa\u0016$\u0018J\u001c%U\u001b2\u0013u\u000eZ=\u0015\u00079\ni\u0004C\u0003J-\u0001\u0007!\n\u000b\u0002\u0017;\u0002")
public interface SearchSnippetGetMethodContract {
    public static /* synthetic */ Duration org$apache$james$jmap$rfc8621$contract$SearchSnippetGetMethodContract$$slowPacedPollInterval$(SearchSnippetGetMethodContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$SearchSnippetGetMethodContract$$slowPacedPollInterval();
    }

    default public Duration org$apache$james$jmap$rfc8621$contract$SearchSnippetGetMethodContract$$slowPacedPollInterval() {
        return Durations.ONE_HUNDRED_MILLISECONDS;
    }

    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$SearchSnippetGetMethodContract$$calmlyAwait$(SearchSnippetGetMethodContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$SearchSnippetGetMethodContract$$calmlyAwait();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$SearchSnippetGetMethodContract$$calmlyAwait() {
        return Awaitility.with().pollInterval(this.org$apache$james$jmap$rfc8621$contract$SearchSnippetGetMethodContract$$slowPacedPollInterval()).and().with().pollDelay(this.org$apache$james$jmap$rfc8621$contract$SearchSnippetGetMethodContract$$slowPacedPollInterval()).await();
    }

    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$SearchSnippetGetMethodContract$$awaitAtMostTenSeconds$(SearchSnippetGetMethodContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$SearchSnippetGetMethodContract$$awaitAtMostTenSeconds();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$SearchSnippetGetMethodContract$$awaitAtMostTenSeconds() {
        return this.org$apache$james$jmap$rfc8621$contract$SearchSnippetGetMethodContract$$calmlyAwait().atMost(10L, TimeUnit.SECONDS);
    }

    public static /* synthetic */ void setUp$(SearchSnippetGetMethodContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addDomain("domain-alias.tld").addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void subjectShouldBeInSearchSnippetWhenMatched$(SearchSnippetGetMethodContract $this, GuiceJamesServer server) {
        $this.subjectShouldBeInSearchSnippetWhenMatched(server);
    }

    @Test
    default public void subjectShouldBeInSearchSnippetWhenMatched(GuiceJamesServer server) {
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()), MessageManager.AppendCommand.builder().build(Message.Builder.of().setSubject("Yet another day in paradise").setBody("testmail", StandardCharsets.UTF_8).build())).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"SearchSnippet/get\",\n         |    {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"filter\" : {\n         |        \"subject\": \"paradise\"\n         |      },\n         |      \"emailIds\": [\"" + messageId.serialize() + "\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$SearchSnippetGetMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n             |  \"SearchSnippet/get\",\n             |  {\n             |    \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n             |    \"list\": [\n             |      {\n             |        \"emailId\": \"" + messageId.serialize() + "\",\n             |        \"subject\": \"Yet another day in <mark>paradise</mark>\",\n             |        \"preview\": null\n             |      }\n             |    ],\n             |    \"notFound\": []\n             |  },\n             |  \"c1\"\n             |]")));
        });
    }

    public static /* synthetic */ void previewShouldBeInSearchSnippetWhenMatched$(SearchSnippetGetMethodContract $this, GuiceJamesServer server) {
        $this.previewShouldBeInSearchSnippetWhenMatched(server);
    }

    @Test
    default public void previewShouldBeInSearchSnippetWhenMatched(GuiceJamesServer server) {
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()), MessageManager.AppendCommand.builder().build(Message.Builder.of().setBody("You can close this page and return to the IDE intellij", StandardCharsets.UTF_8).setSubject("Yet another day in paradise").build())).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"SearchSnippet/get\",\n         |    {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"filter\" : {\n         |        \"body\": \"IDE\"\n         |      },\n         |      \"emailIds\": [\"" + messageId.serialize() + "\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$SearchSnippetGetMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            ResponseBodyExtractionOptions response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body();
            JsonAssertions.assertThatJson((Object)response.asString()).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n             |  \"SearchSnippet/get\",\n             |  {\n             |    \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n             |    \"list\": [\n             |      {\n             |        \"emailId\": \"" + messageId.serialize() + "\",\n             |        \"subject\": null,\n             |        \"preview\": \"${json-unit.ignore}\"\n             |      }\n             |    ],\n             |    \"notFound\": []\n             |  },\n             |  \"c1\"\n             |]")));
            Assertions.assertThat((String)response.jsonPath().get("methodResponses[0][1].list[0].preview").toString()).contains(new CharSequence[]{"return to the <mark>IDE</mark> intellij"});
        });
    }

    public static /* synthetic */ void searchSnippetGetShouldSupportBackReference$(SearchSnippetGetMethodContract $this, GuiceJamesServer server) {
        $this.searchSnippetGetShouldSupportBackReference(server);
    }

    @Test
    default public void searchSnippetGetShouldSupportBackReference(GuiceJamesServer server) {
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()), MessageManager.AppendCommand.builder().build(Message.Builder.of().setBody("You can close this page and return to the IDE intellij", StandardCharsets.UTF_8).setSubject("Yet another day in paradise").build())).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\n         |        \"urn:ietf:params:jmap:core\",\n         |        \"urn:ietf:params:jmap:mail\"\n         |    ],\n         |    \"methodCalls\": [\n         |        [\n         |            \"Email/query\",\n         |            {\n         |                \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |                \"filter\": {\n         |                    \"body\": \"IDE\"\n         |                },\n         |                \"sort\": [\n         |                    {\n         |                        \"isAscending\": false,\n         |                        \"property\": \"receivedAt\"\n         |                    }\n         |                ],\n         |                \"limit\": 20\n         |            },\n         |            \"c0\"\n         |        ],\n         |        [\n         |            \"SearchSnippet/get\",\n         |            {\n         |                \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |                \"filter\": {\n         |                    \"body\": \"IDE\"\n         |                },\n         |                \"#emailIds\": {\n         |                    \"resultOf\": \"c0\",\n         |                    \"name\": \"Email/query\",\n         |                    \"path\": \"/ids/*\"\n         |                }\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$SearchSnippetGetMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            ResponseBodyExtractionOptions response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body();
            JsonAssertions.assertThatJson((Object)response.asString()).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).inPath("methodResponses[1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n             |  \"SearchSnippet/get\",\n             |  {\n             |    \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n             |    \"list\": [\n             |      {\n             |        \"emailId\": \"" + messageId.serialize() + "\",\n             |        \"subject\": null,\n             |        \"preview\": \"${json-unit.ignore}\"\n             |      }\n             |    ],\n             |    \"notFound\": []\n             |  },\n             |  \"c1\"\n             |]")));
            Assertions.assertThat((String)response.jsonPath().get("methodResponses[1][1].list[0].preview").toString()).contains(new CharSequence[]{"return to the <mark>IDE</mark> intellij"});
        });
    }

    public static /* synthetic */ void searchSnippetShouldAcceptSharedMailboxesWhenExtension$(SearchSnippetGetMethodContract $this, GuiceJamesServer server) {
        $this.searchSnippetShouldAcceptSharedMailboxesWhenExtension(server);
    }

    @Test
    default public void searchSnippetShouldAcceptSharedMailboxesWhenExtension(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxId andreInboxId = mailboxProbe.createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE()));
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE()), MessageManager.AppendCommand.from((Message)Message.Builder.of().setSubject("invite you to a sasuke meeting to discuss").setBody("Please let naruto know if this time works for you or if you would prefer a different time.", StandardCharsets.UTF_8).build())).getMessageId();
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE()), Fixture$.MODULE$.BOB().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Read}));
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\",\n         |    \"urn:apache:james:params:jmap:mail:shares\"],\n         |  \"methodCalls\": [[\n         |    \"SearchSnippet/get\",\n         |    {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"filter\" : {\n         |        \"inMailbox\": \"" + andreInboxId.serialize() + "\",\n         |        \"subject\": \"meeting\"\n         |      },\n         |      \"emailIds\": [\"" + messageId.serialize() + "\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$SearchSnippetGetMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n             |  \"SearchSnippet/get\",\n             |  {\n             |    \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n             |    \"list\": [\n             |      {\n             |        \"emailId\": \"" + messageId.serialize() + "\",\n             |        \"subject\": \"invite you to a sasuke <mark>meeting</mark> to discuss\",\n             |        \"preview\": null\n             |      }\n             |    ],\n             |    \"notFound\": []\n             |  },\n             |  \"c1\"\n             |]")));
        });
    }

    public static /* synthetic */ void searchSnippetShouldNotAcceptSharedMailboxesWhenNotExtension$(SearchSnippetGetMethodContract $this, GuiceJamesServer server) {
        $this.searchSnippetShouldNotAcceptSharedMailboxesWhenNotExtension(server);
    }

    @Test
    default public void searchSnippetShouldNotAcceptSharedMailboxesWhenNotExtension(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxId andreInboxId = mailboxProbe.createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE()));
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE()), MessageManager.AppendCommand.from((Message)Message.Builder.of().setSubject("invite you to a sasuke meeting to discuss").setBody("Please let naruto know if this time works for you or if you would prefer a different time.", StandardCharsets.UTF_8).build())).getMessageId();
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE()), Fixture$.MODULE$.BOB().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Read}));
        Thread.sleep(500L);
        ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n               |  \"using\": [\n               |    \"urn:ietf:params:jmap:core\",\n               |    \"urn:ietf:params:jmap:mail\"],\n               |  \"methodCalls\": [[\n               |    \"SearchSnippet/get\",\n               |    {\n               |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n               |      \"filter\" : {\n               |        \"inMailbox\": \"" + andreInboxId.serialize() + "\",\n               |        \"subject\": \"meeting\"\n               |      },\n               |      \"emailIds\": [\"" + messageId.serialize() + "\"]\n               |    },\n               |    \"c1\"]]\n               |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).body("methodResponses[0][1].list", Matchers.hasSize((int)0), new Object[0]).body("methodResponses[0][1].notFound", Matchers.hasItem((Object)messageId.serialize()), new Object[0]);
    }

    public static /* synthetic */ void searchSnippetShouldNotAcceptNotSharedMailboxes$(SearchSnippetGetMethodContract $this, GuiceJamesServer server) {
        $this.searchSnippetShouldNotAcceptNotSharedMailboxes(server);
    }

    @Test
    default public void searchSnippetShouldNotAcceptNotSharedMailboxes(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxId andreInboxId = mailboxProbe.createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE()));
        MessageId messageId = mailboxProbe.appendMessage(Fixture$.MODULE$.ANDRE().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE()), MessageManager.AppendCommand.from((Message)Message.Builder.of().setSubject("invite you to a sasuke meeting to discuss").setBody("Please let naruto know if this time works for you or if you would prefer a different time.", StandardCharsets.UTF_8).build())).getMessageId();
        Thread.sleep(300L);
        ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n               |  \"using\": [\n               |    \"urn:ietf:params:jmap:core\",\n               |    \"urn:ietf:params:jmap:mail\",\n               |    \"urn:apache:james:params:jmap:mail:shares\"\n               |  ],\n               |  \"methodCalls\": [\n               |    [\n               |      \"SearchSnippet/get\",\n               |      {\n               |        \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n               |        \"filter\": {\n               |          \"inMailbox\": \"" + andreInboxId.serialize() + "\",\n               |          \"subject\": \"meeting\"\n               |        },\n               |        \"emailIds\": [ \"" + messageId.serialize() + "\" ]\n               |      },\n               |      \"c1\"\n               |    ]\n               |  ]\n               |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).body("methodResponses[0][1].list", Matchers.hasSize((int)0), new Object[0]).body("methodResponses[0][1].notFound", Matchers.hasItem((Object)messageId.serialize()), new Object[0]);
    }

    public static /* synthetic */ void shouldReturnMultiSearchSnippetInListWhenMultiMatched$(SearchSnippetGetMethodContract $this, GuiceJamesServer server) {
        $this.shouldReturnMultiSearchSnippetInListWhenMultiMatched(server);
    }

    @Test
    default public void shouldReturnMultiSearchSnippetInListWhenMultiMatched(GuiceJamesServer server) {
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        MessageId messageId1 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()), MessageManager.AppendCommand.builder().build(Message.Builder.of().setSubject("Weekly report - vttran 27/02-03/03/2023").setBody("The weekly report has been in attachment. ", StandardCharsets.UTF_8).build())).getMessageId();
        MessageId messageId2 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()), MessageManager.AppendCommand.builder().build(Message.Builder.of().setSubject("Weekly report - vttran 19/08-23/08/2024").setBody("The weekly report has been in attachment. ", StandardCharsets.UTF_8).build())).getMessageId();
        MessageId messageId3 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()), MessageManager.AppendCommand.builder().build(Message.Builder.of().setSubject("Weekly report - whynotme 12/08-16/08/2024").setBody("The weekly report has been in attachment. ", StandardCharsets.UTF_8).build())).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"SearchSnippet/get\",\n         |    {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"filter\" : {\n         |        \"subject\": \"vttran\"\n         |      },\n         |      \"emailIds\": [\"" + messageId1.serialize() + "\", \"" + messageId2.serialize() + "\", \"" + messageId3.serialize() + "\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$SearchSnippetGetMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n             |  \"SearchSnippet/get\",\n             |  {\n             |    \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n             |    \"list\": [\n             |      {\n             |        \"emailId\": \"" + messageId1.serialize() + "\",\n             |        \"subject\": \"Weekly report - <mark>vttran</mark> 27&#x2F;02-03&#x2F;03&#x2F;2023\",\n             |        \"preview\": null\n             |      },\n             |      {\n             |        \"emailId\": \"" + messageId2.serialize() + "\",\n             |        \"subject\": \"Weekly report - <mark>vttran</mark> 19&#x2F;08-23&#x2F;08&#x2F;2024\",\n             |        \"preview\": null\n             |      }\n             |    ],\n             |    \"notFound\": [\"" + messageId3.serialize() + "\"]\n             |  },\n             |  \"c1\"\n             |]")));
        });
    }

    public static /* synthetic */ void shouldSupportOrOperatorInFilter$(SearchSnippetGetMethodContract $this, GuiceJamesServer server) {
        $this.shouldSupportOrOperatorInFilter(server);
    }

    @Test
    default public void shouldSupportOrOperatorInFilter(GuiceJamesServer server) {
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        MessageId messageId1 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()), MessageManager.AppendCommand.builder().build(Message.Builder.of().setSubject("Weekly report - vttran 27/02-03/03/2023").setBody("The weekly report has been in attachment", StandardCharsets.UTF_8).build())).getMessageId();
        MessageId messageId2 = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()), MessageManager.AppendCommand.builder().build(Message.Builder.of().setSubject("Weekly report - whynotme 19/08-23/08/2024").setBody("The weekly report of vttran has been in attachment", StandardCharsets.UTF_8).build())).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [ \"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\" ],\n         |  \"methodCalls\": [\n         |    [\n         |      \"SearchSnippet/get\",\n         |      {\n         |        \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |        \"filter\": {\n         |          \"operator\": \"OR\",\n         |          \"conditions\": [ { \"subject\": \"vttran\" }, { \"body\": \"vttran\" } ]\n         |        },\n         |        \"emailIds\": [ \"" + messageId1.serialize() + "\", \"" + messageId2.serialize() + "\" ]\n         |      },\n         |      \"c1\"\n         |    ]\n         |  ]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$SearchSnippetGetMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n             |  \"SearchSnippet/get\",\n             |  {\n             |    \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n             |    \"list\": [\n             |      {\n             |        \"emailId\": \"" + messageId1.serialize() + "\",\n             |        \"subject\": \"Weekly report - <mark>vttran</mark> 27&#x2F;02-03&#x2F;03&#x2F;2023\",\n             |        \"preview\": null\n             |      },\n             |      {\n             |        \"emailId\": \"" + messageId2.serialize() + "\",\n             |        \"subject\": null,\n             |        \"preview\": \"The weekly report of <mark>vttran</mark> has been in attachment\"\n             |      }\n             |    ],\n             |    \"notFound\": []\n             |  },\n             |  \"c1\"\n             |]")));
        });
    }

    public static /* synthetic */ void shouldReturnEmptyListWhenNotMatched$(SearchSnippetGetMethodContract $this, GuiceJamesServer server) {
        $this.shouldReturnEmptyListWhenNotMatched(server);
    }

    @Test
    default public void shouldReturnEmptyListWhenNotMatched(GuiceJamesServer server) {
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()), MessageManager.AppendCommand.builder().build(Message.Builder.of().setSubject("Weekly report - vttran 27/02-03/03/2023").setBody("The weekly report has been in attachment", StandardCharsets.UTF_8).build())).getMessageId();
        Thread.sleep(500L);
        ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n               |  \"using\": [\n               |    \"urn:ietf:params:jmap:core\",\n               |    \"urn:ietf:params:jmap:mail\"],\n               |  \"methodCalls\": [[\n               |    \"SearchSnippet/get\",\n               |    {\n               |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n               |      \"filter\" : {\n               |        \"subject\": \"whynotme\"\n               |      },\n               |      \"emailIds\": [\"" + messageId.serialize() + "\"]\n               |    },\n               |    \"c1\"]]\n               |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).body("methodResponses[0][1].list", Matchers.hasSize((int)0), new Object[0]).body("methodResponses[0][1].notFound", Matchers.hasItem((Object)messageId.serialize()), new Object[0]);
    }

    public static /* synthetic */ void shouldReturnMatchedSearchSnippetWhenDelegated$(SearchSnippetGetMethodContract $this, GuiceJamesServer server) {
        $this.shouldReturnMatchedSearchSnippetWhenDelegated(server);
    }

    @Test
    default public void shouldReturnMatchedSearchSnippetWhenDelegated(GuiceJamesServer server) {
        ((DelegationProbe)server.getProbe(DelegationProbe.class)).addAuthorizedUser(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.BOB());
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE()));
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE()), MessageManager.AppendCommand.builder().build(Message.Builder.of().setSubject("Yet another day in paradise").setBody("testmail", StandardCharsets.UTF_8).build())).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"SearchSnippet/get\",\n         |    {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |      \"filter\" : {\n         |        \"subject\": \"paradise\"\n         |      },\n         |      \"emailIds\": [\"" + messageId.serialize() + "\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$SearchSnippetGetMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n             |  \"SearchSnippet/get\",\n             |  {\n             |    \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n             |    \"list\": [\n             |      {\n             |        \"emailId\": \"" + messageId.serialize() + "\",\n             |        \"subject\": \"Yet another day in <mark>paradise</mark>\",\n             |        \"preview\": null\n             |      }\n             |    ],\n             |    \"notFound\": []\n             |  },\n             |  \"c1\"\n             |]")));
        });
    }

    public static /* synthetic */ void shouldFailWhenWrongAccountId$(SearchSnippetGetMethodContract $this, GuiceJamesServer server) {
        $this.shouldFailWhenWrongAccountId(server);
    }

    @Test
    default public void shouldFailWhenWrongAccountId(GuiceJamesServer server) {
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()), MessageManager.AppendCommand.builder().build(Message.Builder.of().setSubject("Yet another day in paradise").setBody("testmail", StandardCharsets.UTF_8).build())).getMessageId();
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n               |  \"using\": [\n               |    \"urn:ietf:params:jmap:core\",\n               |    \"urn:ietf:params:jmap:mail\"],\n               |  \"methodCalls\": [[\n               |    \"SearchSnippet/get\",\n               |    {\n               |      \"accountId\": \"unknownAccountId\",\n               |      \"filter\" : {\n               |        \"subject\": \"paradise\"\n               |      },\n               |      \"emailIds\": [\"" + messageId.serialize() + "\"]\n               |    },\n               |    \"c1\"]]\n               |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n           |  \"error\",\n           |  {\n           |    \"type\": \"accountNotFound\"\n           |  },\n           |  \"c1\"\n           |]")));
    }

    public static /* synthetic */ void shouldReturnNotFoundWhenEmailIdDoesNotBelongToAccount$(SearchSnippetGetMethodContract $this, GuiceJamesServer server) {
        $this.shouldReturnNotFoundWhenEmailIdDoesNotBelongToAccount(server);
    }

    @Test
    default public void shouldReturnNotFoundWhenEmailIdDoesNotBelongToAccount(GuiceJamesServer server) {
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE()));
        MessageId messageIdOfAndre = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE()), MessageManager.AppendCommand.builder().build(Message.Builder.of().setSubject("Yet another day in paradise").setBody("testmail", StandardCharsets.UTF_8).build())).getMessageId();
        ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                |  \"using\": [\n                |    \"urn:ietf:params:jmap:core\",\n                |    \"urn:ietf:params:jmap:mail\"],\n                |  \"methodCalls\": [[\n                |    \"SearchSnippet/get\",\n                |    {\n                |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n                |      \"filter\" : {\n                |        \"subject\": \"paradise\"\n                |      },\n                |      \"emailIds\": [\"" + messageIdOfAndre.serialize() + "\"]\n                |    },\n                |    \"c1\"]]\n                |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).body("methodResponses[0][1].list", Matchers.hasSize((int)0), new Object[0]).body("methodResponses[0][1].notFound", Matchers.hasItem((Object)messageIdOfAndre.serialize()), new Object[0]);
    }

    public static /* synthetic */ void shouldFailWhenEmailIdCanNotParse$(SearchSnippetGetMethodContract $this, GuiceJamesServer server) {
        $this.shouldFailWhenEmailIdCanNotParse(server);
    }

    @Test
    default public void shouldFailWhenEmailIdCanNotParse(GuiceJamesServer server) {
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:mail\"],\n           |  \"methodCalls\": [[\n           |    \"SearchSnippet/get\",\n           |    {\n           |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n           |      \"filter\" : {\n           |        \"subject\": \"paradise\"\n           |      },\n           |      \"emailIds\": [\"invalidMessageId@\"]\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n           |  \"error\",\n           |  {\n           |    \"type\": \"invalidArguments\",\n           |    \"description\": \"${json-unit.ignore}\"\n           |  },\n           |  \"c1\"\n           |]")));
    }

    public static /* synthetic */ void shouldReturnEmptyListWhenEmailIdsInRequestEmpty$(SearchSnippetGetMethodContract $this, GuiceJamesServer server) {
        $this.shouldReturnEmptyListWhenEmailIdsInRequestEmpty(server);
    }

    @Test
    default public void shouldReturnEmptyListWhenEmailIdsInRequestEmpty(GuiceJamesServer server) {
        ValidatableResponse response = (ValidatableResponse)((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                |  \"using\": [\n                |    \"urn:ietf:params:jmap:core\",\n                |    \"urn:ietf:params:jmap:mail\"],\n                |  \"methodCalls\": [[\n                |    \"SearchSnippet/get\",\n                |    {\n                |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n                |      \"filter\" : {\n                |        \"subject\": \"paradise\"\n                |      },\n                |      \"emailIds\": []\n                |    },\n                |    \"c1\"]]\n                |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).body("methodResponses[0][1].list", Matchers.hasSize((int)0), new Object[0]).body("methodResponses[0][1].notFound", Matchers.hasSize((int)0), new Object[0]);
    }

    public static /* synthetic */ void shouldReturnUnknownMethodWhenMissingOneCapability$(SearchSnippetGetMethodContract $this, GuiceJamesServer server) {
        $this.shouldReturnUnknownMethodWhenMissingOneCapability(server);
    }

    @Test
    default public void shouldReturnUnknownMethodWhenMissingOneCapability(GuiceJamesServer server) {
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()), MessageManager.AppendCommand.builder().build(Message.Builder.of().setSubject("Yet another day in paradise").setBody("testmail", StandardCharsets.UTF_8).build())).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\"\n         |  ],\n         |  \"methodCalls\": [[\n         |    \"SearchSnippet/get\",\n         |    {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"filter\" : {\n         |        \"subject\": \"paradise\"\n         |      },\n         |      \"emailIds\": [\"" + messageId.serialize() + "\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n           |  \"error\",\n           |  {\n           |    \"type\": \"unknownMethod\",\n           |    \"description\": \"Missing capability(ies): urn:ietf:params:jmap:mail\"\n           |  },\n           |  \"c1\"\n           |]")));
    }

    public static /* synthetic */ void shouldReturnUnknownMethodWhenMissingAllCapabilities$(SearchSnippetGetMethodContract $this, GuiceJamesServer server) {
        $this.shouldReturnUnknownMethodWhenMissingAllCapabilities(server);
    }

    @Test
    default public void shouldReturnUnknownMethodWhenMissingAllCapabilities(GuiceJamesServer server) {
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()), MessageManager.AppendCommand.builder().build(Message.Builder.of().setSubject("Yet another day in paradise").setBody("testmail", StandardCharsets.UTF_8).build())).getMessageId();
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [],\n         |  \"methodCalls\": [[\n         |    \"SearchSnippet/get\",\n         |    {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |      \"filter\" : {\n         |        \"subject\": \"paradise\"\n         |      },\n         |      \"emailIds\": [\"" + messageId.serialize() + "\"]\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).inPath("methodResponses[0]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n           |  \"error\",\n           |  {\n           |    \"type\": \"unknownMethod\",\n           |    \"description\": \"Missing capability(ies): urn:ietf:params:jmap:core, urn:ietf:params:jmap:mail\"\n           |  },\n           |  \"c1\"\n           |]")));
    }

    public static /* synthetic */ void shouldReturnMatchingResultWhenSearchSnippetInHTMLBody$(SearchSnippetGetMethodContract $this, GuiceJamesServer server) {
        $this.shouldReturnMatchingResultWhenSearchSnippetInHTMLBody(server);
    }

    @Test
    default public void shouldReturnMatchingResultWhenSearchSnippetInHTMLBody(GuiceJamesServer server) {
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        MailboxId inboxId = mailboxProbe.createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        MessageId messageId1 = mailboxProbe.appendMessage(Fixture$.MODULE$.BOB().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()), MessageManager.AppendCommand.from((SharedInputStream)ClassLoaderUtils.getSystemResourceAsSharedStream((String)"eml/html_body.eml"))).getMessageId();
        String keywordSearch = "barcamp";
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"using\": [\n         |        \"urn:ietf:params:jmap:core\",\n         |        \"urn:ietf:params:jmap:mail\"\n         |    ],\n         |    \"methodCalls\": [\n         |        [\n         |            \"Email/query\",\n         |            {\n         |                \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |                \"filter\": {\n         |                    \"body\": \"" + keywordSearch + "\"\n         |                },\n         |                \"sort\": [\n         |                    {\n         |                        \"isAscending\": false,\n         |                        \"property\": \"receivedAt\"\n         |                    }\n         |                ],\n         |                \"limit\": 20\n         |            },\n         |            \"c0\"\n         |        ],\n         |        [\n         |            \"SearchSnippet/get\",\n         |            {\n         |                \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |                \"filter\": {\n         |                    \"body\": \"" + keywordSearch + "\"\n         |                },\n         |                \"#emailIds\": {\n         |                    \"resultOf\": \"c0\",\n         |                    \"name\": \"Email/query\",\n         |                    \"path\": \"/ids/*\"\n         |                }\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}"));
        this.org$apache$james$jmap$rfc8621$contract$SearchSnippetGetMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            ResponseBodyExtractionOptions response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body();
            JsonAssertions.assertThatJson((Object)response.asString()).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).inPath("methodResponses[1]").isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("[\n             |  \"SearchSnippet/get\",\n             |  {\n             |    \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n             |    \"list\": [\n             |      {\n             |        \"emailId\": \"" + messageId1.serialize() + "\",\n             |        \"subject\": null,\n             |        \"preview\": \"${json-unit.ignore}\"\n             |      }\n             |    ],\n             |    \"notFound\": []\n             |  },\n             |  \"c1\"\n             |]")));
            Assertions.assertThat((String)response.jsonPath().get("methodResponses[1][1].list[0].preview").toString()).contains(new CharSequence[]{"<mark>" + keywordSearch + "</mark>"});
        });
    }

    public static void $init$(SearchSnippetGetMethodContract $this) {
    }
}

