/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import com.google.common.base.Strings;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.builder.ResponseSpecBuilder;
import io.restassured.response.Validatable;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.jmap.rfc8621.contract.QuotaMailingTest$;
import org.apache.james.junit.categories.BasicFeature;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.modules.QuotaProbesImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.experimental.categories.Category;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001ds!\u0002\t\u0012\u0011\u0003qb!\u0002\u0011\u0012\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003b\u0002\u0016\u0002\u0005\u0004%Ia\u000b\u0005\u0007i\u0005\u0001\u000b\u0011\u0002\u0017\u0007\u000f\u0001\n\u0002\u0013aA\u0001k!)a'\u0002C\u0001o!A1(\u0002EC\u0002\u0013%A\b\u0003\u0005F\u000b!\u0015\r\u0011\"\u0003G\u0011!yU\u0001#b\u0001\n\u00131\u0005\"\u0002)\u0006\t\u0003\t\u0006\"B2\u0006\t\u0003!\u0007\"\u0002?\u0006\t\u0003i\bbBA\u0001\u000b\u0011%\u00111\u0001\u0005\b\u0003\u000f)A\u0011BA\u0005\u0011\u001d\ti#\u0002C\u0005\u0003_\t\u0001#U;pi\u0006l\u0015-\u001b7j]\u001e$Vm\u001d;\u000b\u0005I\u0019\u0012\u0001C2p]R\u0014\u0018m\u0019;\u000b\u0005Q)\u0012a\u0002:gGb2$'\r\u0006\u0003-]\tAA[7ba*\u0011\u0001$G\u0001\u0006U\u0006lWm\u001d\u0006\u00035m\ta!\u00199bG\",'\"\u0001\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005}\tQ\"A\t\u0003!E+x\u000e^1NC&d\u0017N\\4UKN$8CA\u0001#!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AH\u0001\u0010C:$'/\u001a#sC\u001a$8\u000fU1uQV\tA\u0006\u0005\u0002.e5\taF\u0003\u00020a\u0005)Qn\u001c3fY*\u0011\u0011gF\u0001\b[\u0006LGNY8y\u0013\t\u0019dFA\u0006NC&d'm\u001c=QCRD\u0017\u0001E1oIJ,GI]1giN\u0004\u0016\r\u001e5!'\t)!%\u0001\u0004%S:LG\u000f\n\u000b\u0002qA\u00111%O\u0005\u0003u\u0011\u0012A!\u00168ji\u0006)2\u000f\\8x!\u0006\u001cW\r\u001a)pY2Le\u000e^3sm\u0006dW#A\u001f\u0011\u0005y\u001aU\"A \u000b\u0005\u0001\u000b\u0015\u0001\u0002;j[\u0016T\u0011AQ\u0001\u0005U\u00064\u0018-\u0003\u0002E\u007f\tAA)\u001e:bi&|g.A\u0006dC2lG._!xC&$X#A$\u0011\u0005!kU\"A%\u000b\u0005)[\u0015\u0001B2pe\u0016T!\u0001T\u000e\u0002\u0015\u0005<\u0018-\u001b;jY&$\u00180\u0003\u0002O\u0013\n\u00012i\u001c8eSRLwN\u001c$bGR|'/_\u0001\u0016C^\f\u0017\u000e^!u\u001b>\u001cH\u000fV<p\u001b&tW\u000f^3t\u0003\u0015\u0019X\r^+q)\tA$\u000bC\u0003T\u0015\u0001\u0007A+\u0001\u0004tKJ4XM\u001d\t\u0003+Zk\u0011aF\u0005\u0003/^\u0011\u0001cR;jG\u0016T\u0015-\\3t'\u0016\u0014h/\u001a:)\u0005)I\u0006C\u0001.b\u001b\u0005Y&B\u0001/^\u0003\r\t\u0007/\u001b\u0006\u0003=~\u000bqA[;qSR,'O\u0003\u0002a7\u0005)!.\u001e8ji&\u0011!m\u0017\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017AJ:i_VdGmU3oI\u0006su\u000e^5dK^CWM\u001c+ie\u0016\u001c\bn\u001c7e\u000bb\u001cW-\u001a3fIR\u0011\u0001(\u001a\u0005\u0006'.\u0001\r\u0001\u0016\u0015\u0005\u0017\u001d|\u0007\u000f\u0005\u0002i[6\t\u0011N\u0003\u0002kW\u0006Q1-\u0019;fO>\u0014\u0018.Z:\u000b\u00051|\u0016\u0001D3ya\u0016\u0014\u0018.\\3oi\u0006d\u0017B\u00018j\u0005!\u0019\u0015\r^3h_JL\u0018!\u0002<bYV,G&A9$\u0003I\u0004\"a\u001d<\u000e\u0003QT!A[;\u000b\u0005\u0001<\u0012BA<u\u00051\u0011\u0015m]5d\r\u0016\fG/\u001e:fQ\tY\u0011\u0010\u0005\u0002[u&\u00111p\u0017\u0002\u0005)\u0016\u001cH/A\u0010d_:4\u0017nZ;sCRLwN\\*i_VdGMQ3XK2dGj\\1eK\u0012$\"\u0001\u000f@\t\u000bMc\u0001\u0019\u0001+)\u00051I\u0018AE1oIJ,7+\u001a8e\u001b\u0006LG\u000eV8C_\n$2\u0001OA\u0003\u0011\u0015\u0019V\u00021\u0001U\u00039a\u0017n\u001d;NKN\u001c\u0018mZ3JIN$\"!a\u0003\u0011\r\u00055\u00111CA\f\u001b\t\tyAC\u0002\u0002\u0012\u0005\u000bA!\u001e;jY&!\u0011QCA\b\u0005%\t%O]1z\u0019&\u001cH\u000f\u0005\u0003\u0002\u001a\u0005\u001db\u0002BA\u000e\u0003G\u00012!!\b%\u001b\t\tyBC\u0002\u0002\"u\ta\u0001\u0010:p_Rt\u0014bAA\u0013I\u00051\u0001K]3eK\u001aLA!!\u000b\u0002,\t11\u000b\u001e:j]\u001eT1!!\n%\u0003A\u0019wN\\2bi6+7o]1hK&#7\u000f\u0006\u0003\u0002\u0018\u0005E\u0002bBA\u001a\u001f\u0001\u0007\u0011QG\u0001\u0004S\u0012\u001c\bCBA\u001c\u0003\u0003\n9B\u0004\u0003\u0002:\u0005ub\u0002BA\u000f\u0003wI\u0011!J\u0005\u0004\u0003\u007f!\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0007\n)E\u0001\u0003MSN$(bAA I\u0001")
public interface QuotaMailingTest {
    public static /* synthetic */ Duration org$apache$james$jmap$rfc8621$contract$QuotaMailingTest$$slowPacedPollInterval$(QuotaMailingTest $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$QuotaMailingTest$$slowPacedPollInterval();
    }

    default public Duration org$apache$james$jmap$rfc8621$contract$QuotaMailingTest$$slowPacedPollInterval() {
        return Durations.ONE_HUNDRED_MILLISECONDS;
    }

    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$QuotaMailingTest$$calmlyAwait$(QuotaMailingTest $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$QuotaMailingTest$$calmlyAwait();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$QuotaMailingTest$$calmlyAwait() {
        return Awaitility.with().pollInterval(this.org$apache$james$jmap$rfc8621$contract$QuotaMailingTest$$slowPacedPollInterval()).and().with().pollDelay(this.org$apache$james$jmap$rfc8621$contract$QuotaMailingTest$$slowPacedPollInterval()).await();
    }

    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$QuotaMailingTest$$awaitAtMostTwoMinutes$(QuotaMailingTest $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$QuotaMailingTest$$awaitAtMostTwoMinutes();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$QuotaMailingTest$$awaitAtMostTwoMinutes() {
        return this.org$apache$james$jmap$rfc8621$contract$QuotaMailingTest$$calmlyAwait().atMost(2L, TimeUnit.MINUTES);
    }

    public static /* synthetic */ void setUp$(QuotaMailingTest $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD());
        MailboxProbeImpl mailboxProbe = (MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class);
        mailboxProbe.createMailbox("#private", Fixture$.MODULE$.BOB().asString(), "INBOX");
        mailboxProbe.createMailbox("#private", Fixture$.MODULE$.ANDRE().asString(), "INBOX");
        mailboxProbe.createMailbox(QuotaMailingTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$QuotaMailingTest$$andreDraftsPath());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void shouldSendANoticeWhenThresholdExceeded$(QuotaMailingTest $this, GuiceJamesServer server) {
        $this.shouldSendANoticeWhenThresholdExceeded(server);
    }

    @Category(value={BasicFeature.class})
    @Test
    default public void shouldSendANoticeWhenThresholdExceeded(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        quotaProbe.setMaxStorage(quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB())), QuotaSizeLimit.size((long)100000L));
        this.andreSendMailToBob(server);
        this.org$apache$james$jmap$rfc8621$contract$QuotaMailingTest$$awaitAtMostTwoMinutes().until(() -> Predef$.MODULE$.boolean2Boolean(this.listMessageIds().size() == 2));
        List ids = CollectionConverters$.MODULE$.ListHasAsScala(this.listMessageIds()).asScala().toList();
        String idString = this.concatMessageIds((List<String>)ids);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\",\"urn:ietf:params:jmap:mail\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |     \"Email/get\",\n         |     {\n         |       \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |       \"ids\": [" + idString + "]\n         |     },\n         |     \"c1\"]]\n         |}"));
        ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).log().ifValidationFails().body("methodResponses[0][1].list.subject", Matchers.hasItem((Object)"Warning: Your email usage just exceeded a configured threshold"), new Object[0]);
    }

    public static /* synthetic */ void configurationShouldBeWellLoaded$(QuotaMailingTest $this, GuiceJamesServer server) {
        $this.configurationShouldBeWellLoaded(server);
    }

    @Test
    default public void configurationShouldBeWellLoaded(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        quotaProbe.setMaxStorage(quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB())), QuotaSizeLimit.size((long)100000L));
        this.andreSendMailToBob(server);
        this.org$apache$james$jmap$rfc8621$contract$QuotaMailingTest$$awaitAtMostTwoMinutes().until(() -> Predef$.MODULE$.boolean2Boolean(this.listMessageIds().size() == 2));
        this.andreSendMailToBob(server);
        this.org$apache$james$jmap$rfc8621$contract$QuotaMailingTest$$awaitAtMostTwoMinutes().until(() -> Predef$.MODULE$.boolean2Boolean(this.listMessageIds().size() == 4));
        List ids = CollectionConverters$.MODULE$.ListHasAsScala(this.listMessageIds()).asScala().toList();
        String idString = this.concatMessageIds((List<String>)ids);
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\",\"urn:ietf:params:jmap:mail\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |     \"Email/get\",\n         |     {\n         |       \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\",\n         |       \"ids\": [" + idString + "]\n         |     },\n         |     \"c1\"]]\n         |}"));
        ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).log().ifValidationFails().body("methodResponses[0][1].list.preview", Matchers.hasItem((Matcher)Matchers.containsString((String)"You currently occupy more than 10 % of the total size allocated to you")), new Object[0]).body("methodResponses[0][1].list.preview", Matchers.hasItem((Matcher)Matchers.containsString((String)"You currently occupy more than 20 % of the total size allocated to you")), new Object[0]);
    }

    private void andreSendMailToBob(GuiceJamesServer server) {
        Message message = Message.Builder.of().setSubject("test").setSender(Fixture$.MODULE$.ANDRE().asString()).setFrom("ANDRE <" + Fixture$.MODULE$.ANDRE().asString() + ">").setTo(Fixture$.MODULE$.BOB().asString()).setBody(Strings.repeat((String)"123456789\n", (int)1200), StandardCharsets.UTF_8).build();
        MessageId messageId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.ANDRE().asString(), QuotaMailingTest$.MODULE$.org$apache$james$jmap$rfc8621$contract$QuotaMailingTest$$andreDraftsPath(), MessageManager.AppendCommand.builder().build(message)).getMessageId();
        String requestAndre = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [\n         |     [\"EmailSubmission/set\", {\n         |       \"accountId\": \"" + Fixture$.MODULE$.ANDRE_ACCOUNT_ID() + "\",\n         |       \"create\": {\n         |         \"k1490\": {\n         |           \"emailId\": \"" + messageId.serialize() + "\",\n         |           \"envelope\": {\n         |             \"mailFrom\": {\"email\": \"" + Fixture$.MODULE$.ANDRE().asString() + "\"},\n         |             \"rcptTo\": [{\"email\": \"" + Fixture$.MODULE$.BOB().asString() + "\"}]\n         |           }\n         |         }\n         |    }\n         |  }, \"c1\"]]\n         |}"));
        ((Validatable)RestAssured.given((RequestSpecification)Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.ANDRE(), Fixture$.MODULE$.ANDRE_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).setBody(requestAndre).build(), (ResponseSpecification)new ResponseSpecBuilder().build()).post()).then().statusCode(200);
    }

    private ArrayList<String> listMessageIds() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\",\"urn:ietf:params:jmap:mail\", \"urn:ietf:params:jmap:submission\"],\n         |  \"methodCalls\": [[\n         |    \"Email/query\",\n         |    {\n         |      \"accountId\": \"" + Fixture$.MODULE$.ACCOUNT_ID() + "\"\n         |    },\n         |    \"c1\"]]\n         |}"));
        return (ArrayList)((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).extract().body().path("methodResponses[0][1].ids", new String[0]);
    }

    private String concatMessageIds(List<String> ids) {
        return ids.map((Function1 & Serializable)id -> "\"" + id + "\"").mkString(",");
    }

    public static void $init$(QuotaMailingTest $this) {
    }
}

