/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import eu.timepit.refined.api.Refined;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import net.javacrumbs.jsonunit.core.Option;
import org.apache.james.GuiceJamesServer;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.mail.CountResourceType$;
import org.apache.james.jmap.mail.QuotaIdFactory$;
import org.apache.james.jmap.mail.ResourceType;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.modules.ACLProbeImpl;
import org.apache.james.modules.MailboxProbeImpl;
import org.apache.james.modules.QuotaProbesImpl;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005uca\u0002\u000f\u001e!\u0003\r\tA\u000b\u0005\u0006c\u0001!\tA\r\u0005\tm\u0001A)\u0019!C\u0005o!)\u0001\t\u0001C\u0001\u0003\")1\u000b\u0001C\u0001e!)\u0001\f\u0001C\u00013\")A\f\u0001C\u0001;\")\u0001\r\u0001C\u0001C\")A\r\u0001C\u0001K\")\u0001\u000e\u0001C\u0001S\")A\u000e\u0001C\u0001[\")\u0001\u000f\u0001C\u0001c\")A\u000f\u0001C\u0001e!)a\u000f\u0001C\u0001e!)\u0001\u0010\u0001C\u0001e!)!\u0010\u0001C\u0001w\")a\u0010\u0001C\u0001\u007f\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003+\u0001A\u0011AA\f\u0011\u001d\ti\u0002\u0001C\u0001\u0003?Aq!!\n\u0001\t\u0003\t9\u0003C\u0004\u0002.\u0001!\t!a\f\t\u000f\u0005U\u0002\u0001\"\u0001\u00028!9\u0011Q\b\u0001\u0005\u0002\u0005}\u0002bBA#\u0001\u0011\u0005\u0011q\t\u0005\b\u0003\u001b\u0002A\u0011AA(\u0011\u001d\t)\u0006\u0001C\u0001\u0003/\u0012a#U;pi\u0006<U\r^'fi\"|GmQ8oiJ\f7\r\u001e\u0006\u0003=}\t\u0001bY8oiJ\f7\r\u001e\u0006\u0003A\u0005\nqA\u001d4dqY\u0012\u0014G\u0003\u0002#G\u0005!!.\\1q\u0015\t!S%A\u0003kC6,7O\u0003\u0002'O\u00051\u0011\r]1dQ\u0016T\u0011\u0001K\u0001\u0004_J<7\u0001A\n\u0003\u0001-\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012a!\u00118z%\u00164\u0017A\u0002\u0013j]&$H\u0005F\u00014!\taC'\u0003\u00026[\t!QK\\5u\u0003U\tw/Y5u\u0003Rlun\u001d;UK:\u001cVmY8oIN,\u0012\u0001\u000f\t\u0003syj\u0011A\u000f\u0006\u0003wq\nAaY8sK*\u0011QhJ\u0001\u000bC^\f\u0017\u000e^5mSRL\u0018BA ;\u0005A\u0019uN\u001c3ji&|gNR1di>\u0014\u00180A\u0003tKR,\u0006\u000f\u0006\u00024\u0005\")1i\u0001a\u0001\t\u000611/\u001a:wKJ\u0004\"!\u0012$\u000e\u0003\rJ!aR\u0012\u0003!\u001d+\u0018nY3KC6,7oU3sm\u0016\u0014\bFA\u0002J!\tQ\u0015+D\u0001L\u0015\taU*A\u0002ba&T!AT(\u0002\u000f),\b/\u001b;fe*\u0011\u0001kJ\u0001\u0006UVt\u0017\u000e^\u0005\u0003%.\u0013!BQ3g_J,W)Y2i\u0003-b\u0017n\u001d;TQ>,H\u000eZ#naRLx\u000b[3o\u0003\u000e\u001cw.\u001e8u\t>,7OT8u\u0011\u00064X-U;pi\u0006\u001c\bF\u0001\u0003V!\tQe+\u0003\u0002X\u0017\n!A+Z:u\u00031\nXo\u001c;b\u000f\u0016$8\u000b[8vY\u0012\u0014V\r^;s]2K7\u000f^,iK:\fVo\u001c;bg&\u001b\bK]8wS\u0012,G\r\u0006\u000245\")1)\u0002a\u0001\t\"\u0012Q!V\u0001&cV|G/Y$fiNCw.\u001e7e\r&dG/\u001a:PkR,f\u000e\\5nSR,G-U;pi\u0006$\"a\r0\t\u000b\r3\u0001\u0019\u0001#)\u0005\u0019)\u0016\u0001L9v_R\fw)\u001a;TQ>,H\u000e\u001a*fiV\u0014h.R7qifd\u0015n\u001d;XQ\u0016t\u0017\nZ:Be\u0016,U\u000e\u001d;z)\t\u0019$\rC\u0003D\u000f\u0001\u0007A\t\u000b\u0002\b+\u00069\u0013/^8uC\u001e+Go\u00155pk2$'+\u001a;ve:d\u0015n\u001d;XQ\u0016tw\t\\8cC2\fVo\u001c;b)\t\u0019d\rC\u0003D\u0011\u0001\u0007A\t\u000b\u0002\t+\u0006q\u0013/^8uC\u001e+Go\u00155pk2$'+\u001a;ve:tu\u000e\u001e$pk:$w\u000b[3o\u0013\u0012$u.Z:O_R,\u00050[:u)\t\u0019$\u000eC\u0003D\u0013\u0001\u0007A\t\u000b\u0002\n+\u0006y\u0013/^8uC\u001e+Go\u00155pk2$'+\u001a;ve:tu\u000e\u001e$pk:$\u0017I\u001c3MSN$x\u000b[3o\u001b&D8)Y:fgR\u00111G\u001c\u0005\u0006\u0007*\u0001\r\u0001\u0012\u0015\u0003\u0015U\u000b1%];pi\u0006<U\r^*i_VdGMU3ukJt'+[4iiV\u001b\u0018mZ3Rk>$\u0018\r\u0006\u00024e\")1i\u0003a\u0001\t\"\u00121\"V\u0001%cV|G/Y$fiNCw.\u001e7e\r\u0006LGn\u00165f]^\u0013xN\\4BG\u000e|WO\u001c;JI\"\u0012A\"V\u0001,cV|G/Y$fiNCw.\u001e7e\r\u0006LGn\u00165f]>k\u0017\u000e\u001e;j]\u001e|e.Z\"ba\u0006\u0014\u0017\u000e\\5us\"\u0012Q\"V\u0001,cV|G/Y$fiNCw.\u001e7e\r\u0006LGn\u00165f]>k\u0017\u000e\u001e;j]\u001e\fE\u000e\\\"ba\u0006\u0014\u0017\u000e\\5us\"\u0012a\"V\u0001/cV|G/Y$fiNCw.\u001e7e\u001d>$(+\u001a;ve:\fVo\u001c;b\t\u0006$\u0018m\u00144Pi\",'/Q2d_VtG\u000f\u0006\u00024y\")1i\u0004a\u0001\t\"\u0012q\"V\u00012cV|G/Y$fiNCw.\u001e7e%\u0016$XO\u001d8O_R4u.\u001e8e/\",g\u000eR8fg:{G\u000fU3s[&\u001c8/[8o)\r\u0019\u0014\u0011\u0001\u0005\u0006\u0007B\u0001\r\u0001\u0012\u0015\u0003!U\u000bq&];pi\u0006<U\r^*i_VdGMU3ukJt\u0017\nZ,iK:tu\u000e\u0015:pa\u0016\u0014H/[3t%\u0016\fX/Z:uK\u0012$2aMA\u0005\u0011\u0015\u0019\u0015\u00031\u0001EQ\t\tR+A\u0016rk>$\u0018mR3u'\"|W\u000f\u001c3SKR,(O\\(oYf\u0014V-];fgR,G\r\u0015:pa\u0016\u0014H/[3t)\r\u0019\u0014\u0011\u0003\u0005\u0006\u0007J\u0001\r\u0001\u0012\u0015\u0003%U\u000bq%];pi\u0006<U\r^*i_VdGMR1jY^CWM\\%om\u0006d\u0017\u000e\u001a)s_B,'\u000f^5fgR\u00191'!\u0007\t\u000b\r\u001b\u0002\u0019\u0001#)\u0005M)\u0016\u0001I9v_R\fw)\u001a;TQ>,H\u000e\u001a$bS2<\u0006.\u001a8J]Z\fG.\u001b3JIN$2aMA\u0011\u0011\u0015\u0019E\u00031\u0001EQ\t!R+A\u0011rk>$\u0018mR3u'\"|W\u000f\u001c3SKR,(O\\(oYf,6/\u001a:Rk>$\u0018\rF\u00024\u0003SAQaQ\u000bA\u0002\u0011C#!F+\u0002\u0005F,x\u000e^1HKR\u001c\u0006n\\;mI:{GOU3ukJt\u0017+^8uCJ{w\u000e^(g\t\u0016dWmZ1uK\u0012l\u0015-\u001b7c_b<\u0006.\u001a8O_R,\u0005\u0010^3og&|g\u000eF\u00024\u0003cAQa\u0011\fA\u0002\u0011C#AF+\u0002yE,x\u000e^1HKR\u001c\u0006n\\;mIJ+G/\u001e:o#V|G/\u0019*p_R|e\rR3mK\u001e\fG/\u001a3NC&d'm\u001c=XQ\u0016tW\t\u001f;f]NLwN\u001c\u000b\u0004g\u0005e\u0002\"B\"\u0018\u0001\u0004!\u0005FA\fV\u0003\t\u000bXo\u001c;b\u000f\u0016$8\u000b[8vY\u0012\u0014V\r^;s]F+x\u000e^1S_>$xJ\u001a#fY\u0016<\u0017\r^3e\u001b\u0006LGNY8y/\",gNT8u\u0011\u0006\u001c(+Z1e%&<\u0007\u000e\u001e\u000b\u0004g\u0005\u0005\u0003\"B\"\u0019\u0001\u0004!\u0005F\u0001\rV\u0003\r\u000bXo\u001c;b\u000f\u0016$8\u000b[8vY\u0012\u0014V\r^;s]F+x\u000e^1S_>$xJ\u001a#fY\u0016<\u0017\r^3e\u001b\u0006LGNY8y/\",g\u000e\u0015:pm&$WmQ8se\u0016\u001cG/\u00133\u0015\u0007M\nI\u0005C\u0003D3\u0001\u0007A\t\u000b\u0002\u001a+\u0006\u00114\u000f[8vY\u0012\u001cV\u000f\u001d9peR\fVo\u001c;b\u000f\u0016$HI]1gi\u000e{W\u000e]1uS\nLG.\u001b;z/\",g.\u00128bE2,G\rF\u00024\u0003#BQa\u0011\u000eA\u0002\u0011C#AG+\u0002\u007fE,x\u000e^1HKR$%/\u00194u\u0007>l\u0007/\u0019;jE&d\u0017\u000e^=TQ>,H\u000eZ*uS2d7+\u001e9q_J$\bK]8qKJ$\u0018.Z:GS2$XM]5oOR\u00191'!\u0017\t\u000b\r[\u0002\u0019\u0001#)\u0005m)\u0006")
public interface QuotaGetMethodContract {
    public static /* synthetic */ ConditionFactory org$apache$james$jmap$rfc8621$contract$QuotaGetMethodContract$$awaitAtMostTenSeconds$(QuotaGetMethodContract $this) {
        return $this.org$apache$james$jmap$rfc8621$contract$QuotaGetMethodContract$$awaitAtMostTenSeconds();
    }

    default public ConditionFactory org$apache$james$jmap$rfc8621$contract$QuotaGetMethodContract$$awaitAtMostTenSeconds() {
        return Awaitility.with().await().pollInterval(Duration.ofMillis(100L)).atMost(10L, TimeUnit.SECONDS);
    }

    public static /* synthetic */ void setUp$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).addHeader(HttpHeaderNames.ACCEPT.toString(), Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER()).build();
        System.clearProperty("james.jmap.quota.draft.compatibility");
    }

    public static /* synthetic */ void listShouldEmptyWhenAccountDoesNotHaveQuotas$(QuotaGetMethodContract $this) {
        $this.listShouldEmptyWhenAccountDoesNotHaveQuotas();
    }

    @Test
    default public void listShouldEmptyWhenAccountDoesNotHaveQuotas() {
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/get\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"ids\": null\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [[\n         |    \"Quota/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"state\": \"1a9d5db2-2c73-3993-bf0b-42f64b396873\",\n         |      \"list\": [],\n         |      \"notFound\": []\n         |    },\n         |    \"c1\"]]\n         |}")));
    }

    public static /* synthetic */ void quotaGetShouldReturnListWhenQuotasIsProvided$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.quotaGetShouldReturnListWhenQuotasIsProvided(server);
    }

    @Test
    default public void quotaGetShouldReturnListWhenQuotasIsProvided(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        quotaProbe.setMaxStorage(bobQuotaRoot, QuotaSizeLimit.size((long)99L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/get\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"ids\": null\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/get\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"notFound\": [],\n         |                \"state\": \"6d7199ed-f1ce-31f3-8f02-c2e824004e55\",\n         |                \"list\": [\n         |                    {\n         |                        \"used\": 0,\n         |                        \"name\": \"#private&bob@domain.tld@domain.tld:account:count:Mail\",\n         |                        \"id\": \"08417be420b6dd6fa77d48fb2438e0d19108cd29424844bb109b52d356fab528\",\n         |                        \"types\": [\n         |                            \"Mail\"\n         |                        ],\n         |                        \"hardLimit\": 100,\n         |                        \"warnLimit\": 90,\n         |                        \"resourceType\": \"count\",\n         |                        \"scope\": \"account\"\n         |                    },\n         |                    {\n         |                        \"used\": 0,\n         |                        \"name\": \"#private&bob@domain.tld@domain.tld:account:octets:Mail\",\n         |                        \"id\": \"eab6ce8ac5d9730a959e614854410cf39df98ff3760a623b8e540f36f5184947\",\n         |                        \"types\": [\n         |                            \"Mail\"\n         |                        ],\n         |                        \"hardLimit\": 99,\n         |                        \"warnLimit\": 89,\n         |                        \"resourceType\": \"octets\",\n         |                        \"scope\": \"account\"\n         |                    }\n         |                ]\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}\n         |")));
    }

    public static /* synthetic */ void quotaGetShouldFilterOutUnlimitedQuota$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.quotaGetShouldFilterOutUnlimitedQuota(server);
    }

    @Test
    default public void quotaGetShouldFilterOutUnlimitedQuota(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        quotaProbe.setMaxStorage(bobQuotaRoot, QuotaSizeLimit.unlimited());
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/get\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"ids\": null\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/get\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"notFound\": [],\n         |                \"state\": \"84c40a2e-76a1-3f84-a1e8-862104c7a697\",\n         |                \"list\": [\n         |                    {\n         |                        \"used\": 0,\n         |                        \"name\": \"#private&bob@domain.tld@domain.tld:account:count:Mail\",\n         |                        \"id\": \"08417be420b6dd6fa77d48fb2438e0d19108cd29424844bb109b52d356fab528\",\n         |                        \"types\": [\n         |                            \"Mail\"\n         |                        ],\n         |                        \"hardLimit\": 100,\n         |                        \"warnLimit\": 90,\n         |                        \"resourceType\": \"count\",\n         |                        \"scope\": \"account\"\n         |                    }\n         |                ]\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}\n         |")));
    }

    public static /* synthetic */ void quotaGetShouldReturnEmptyListWhenIdsAreEmpty$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.quotaGetShouldReturnEmptyListWhenIdsAreEmpty(server);
    }

    @Test
    default public void quotaGetShouldReturnEmptyListWhenIdsAreEmpty(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/get\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"ids\": []\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/get\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"notFound\": [],\n         |                \"state\": \"84c40a2e-76a1-3f84-a1e8-862104c7a697\",\n         |                \"list\": []\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}\n         |")));
    }

    public static /* synthetic */ void quotaGetShouldReturnListWhenGlobalQuota$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.quotaGetShouldReturnListWhenGlobalQuota(server);
    }

    @Test
    default public void quotaGetShouldReturnListWhenGlobalQuota(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        quotaProbe.setGlobalMaxMessageCount(QuotaCountLimit.count((long)100L));
        quotaProbe.setGlobalMaxStorage(QuotaSizeLimit.size((long)99L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/get\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"ids\": null\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"Quota/get\",\n           |            {\n           |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |                \"notFound\": [],\n           |                \"state\": \"6d7199ed-f1ce-31f3-8f02-c2e824004e55\",\n           |                \"list\": [\n           |                    {\n           |                        \"used\": 0,\n           |                        \"name\": \"#private&bob@domain.tld@domain.tld:account:count:Mail\",\n           |                        \"id\": \"08417be420b6dd6fa77d48fb2438e0d19108cd29424844bb109b52d356fab528\",\n           |                        \"types\": [\n           |                            \"Mail\"\n           |                        ],\n           |                        \"hardLimit\": 100,\n           |                        \"warnLimit\": 90,\n           |                        \"resourceType\": \"count\",\n           |                        \"scope\": \"account\"\n           |                    },\n           |                    {\n           |                        \"used\": 0,\n           |                        \"name\": \"#private&bob@domain.tld@domain.tld:account:octets:Mail\",\n           |                        \"id\": \"eab6ce8ac5d9730a959e614854410cf39df98ff3760a623b8e540f36f5184947\",\n           |                        \"types\": [\n           |                            \"Mail\"\n           |                        ],\n           |                        \"hardLimit\": 99,\n           |                        \"warnLimit\": 89,\n           |                        \"resourceType\": \"octets\",\n           |                        \"scope\": \"account\"\n           |                    }\n           |                ]\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}\n           |")));
    }

    public static /* synthetic */ void quotaGetShouldReturnNotFoundWhenIdDoesNotExist$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.quotaGetShouldReturnNotFoundWhenIdDoesNotExist(server);
    }

    @Test
    default public void quotaGetShouldReturnNotFoundWhenIdDoesNotExist(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/get\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"ids\": [\"notfound123\"]\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/get\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"notFound\": [ \"notfound123\" ],\n         |                \"state\": \"84c40a2e-76a1-3f84-a1e8-862104c7a697\",\n         |                \"list\": []\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}\n         |")));
    }

    public static /* synthetic */ void quotaGetShouldReturnNotFoundAndListWhenMixCases$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.quotaGetShouldReturnNotFoundAndListWhenMixCases(server);
    }

    @Test
    default public void quotaGetShouldReturnNotFoundAndListWhenMixCases(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        quotaProbe.setMaxStorage(bobQuotaRoot, QuotaSizeLimit.size((long)900L));
        String quotaId = QuotaIdFactory$.MODULE$.from(bobQuotaRoot, (ResourceType)CountResourceType$.MODULE$);
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/get\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"ids\": [\"notfound123\", \"" + quotaId + "\"]\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/get\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"notFound\": [ \"notfound123\" ],\n         |                \"state\": \"461cef39-0c47-352b-a9e9-052093c20d5d\",\n         |                \"list\": [\n         |                    {\n         |                        \"used\": 0,\n         |                        \"name\": \"#private&bob@domain.tld@domain.tld:account:count:Mail\",\n         |                        \"id\": \"08417be420b6dd6fa77d48fb2438e0d19108cd29424844bb109b52d356fab528\",\n         |                        \"types\": [\n         |                            \"Mail\"\n         |                        ],\n         |                        \"hardLimit\": 100,\n         |                        \"warnLimit\": 90,\n         |                        \"resourceType\": \"count\",\n         |                        \"scope\": \"account\"\n         |                    }\n         |                ]\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}\n         |")));
    }

    public static /* synthetic */ void quotaGetShouldReturnRightUsageQuota$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.quotaGetShouldReturnRightUsageQuota(server);
    }

    @Test
    default public void quotaGetShouldReturnRightUsageQuota(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        quotaProbe.setMaxStorage(bobQuotaRoot, QuotaSizeLimit.size((long)900L));
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()), MessageManager.AppendCommand.from((Message)Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build())).getMessageId().serialize();
        this.org$apache$james$jmap$rfc8621$contract$QuotaGetMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |  \"using\": [\n             |    \"urn:ietf:params:jmap:core\",\n             |    \"urn:ietf:params:jmap:quota\"],\n             |  \"methodCalls\": [[\n             |    \"Quota/get\",\n             |    {\n             |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |      \"ids\": null\n             |    },\n             |    \"c1\"]]\n             |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |        [\n             |            \"Quota/get\",\n             |            {\n             |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |                \"notFound\": [ ],\n             |                \"state\": \"3c51d50a-d766-38b7-9fa4-c9ff12de87a4\",\n             |                \"list\": [\n             |                    {\n             |                        \"used\": 1,\n             |                        \"name\": \"#private&bob@domain.tld@domain.tld:account:count:Mail\",\n             |                        \"id\": \"08417be420b6dd6fa77d48fb2438e0d19108cd29424844bb109b52d356fab528\",\n             |                        \"types\": [\n             |                            \"Mail\"\n             |                        ],\n             |                        \"hardLimit\": 100,\n             |                        \"warnLimit\": 90,\n             |                        \"resourceType\": \"count\",\n             |                        \"scope\": \"account\"\n             |                    },\n             |                    {\n             |                        \"used\": 85,\n             |                        \"name\": \"#private&bob@domain.tld@domain.tld:account:octets:Mail\",\n             |                        \"id\": \"eab6ce8ac5d9730a959e614854410cf39df98ff3760a623b8e540f36f5184947\",\n             |                        \"types\": [\n             |                            \"Mail\"\n             |                        ],\n             |                        \"hardLimit\": 900,\n             |                        \"warnLimit\": 810,\n             |                        \"resourceType\": \"octets\",\n             |                        \"scope\": \"account\"\n             |                    }\n             |                ]\n             |            },\n             |            \"c1\"\n             |        ]\n             |    ]\n             |}\n             |")));
        });
    }

    public static /* synthetic */ void quotaGetShouldFailWhenWrongAccountId$(QuotaGetMethodContract $this) {
        $this.quotaGetShouldFailWhenWrongAccountId();
    }

    @Test
    default public void quotaGetShouldFailWhenWrongAccountId() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\",\n         |    \"urn:ietf:params:jmap:quota\"],\n         |  \"methodCalls\": [[\n         |    \"Quota/get\",\n         |    {\n         |      \"accountId\": \"unknownAccountId\",\n         |      \"ids\": null\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().log().ifValidationFails().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [\n         |    [\"error\", {\n         |      \"type\": \"accountNotFound\"\n         |    }, \"c1\"]\n         |  ]\n         |}")));
    }

    public static /* synthetic */ void quotaGetShouldFailWhenOmittingOneCapability$(QuotaGetMethodContract $this) {
        $this.quotaGetShouldFailWhenOmittingOneCapability();
    }

    @Test
    default public void quotaGetShouldFailWhenOmittingOneCapability() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\n         |    \"urn:ietf:params:jmap:core\"],\n         |  \"methodCalls\": [[\n         |    \"Quota/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": null\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().log().ifValidationFails().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [[\n         |    \"error\",\n         |    {\n         |      \"type\": \"unknownMethod\",\n         |      \"description\":\"Missing capability(ies): urn:ietf:params:jmap:quota\"\n         |    },\n         |    \"c1\"]]\n         |}")));
    }

    public static /* synthetic */ void quotaGetShouldFailWhenOmittingAllCapability$(QuotaGetMethodContract $this) {
        $this.quotaGetShouldFailWhenOmittingAllCapability();
    }

    @Test
    default public void quotaGetShouldFailWhenOmittingAllCapability() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [],\n         |  \"methodCalls\": [[\n         |    \"Quota/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"ids\": null\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().body(request).when().post()).then().log().ifValidationFails().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [[\n         |    \"error\",\n         |    {\n         |      \"type\": \"unknownMethod\",\n         |      \"description\":\"Missing capability(ies): urn:ietf:params:jmap:quota, urn:ietf:params:jmap:core\"\n         |    },\n         |    \"c1\"]]\n         |}")));
    }

    public static /* synthetic */ void quotaGetShouldNotReturnQuotaDataOfOtherAccount$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.quotaGetShouldNotReturnQuotaDataOfOtherAccount(server);
    }

    @Test
    default public void quotaGetShouldNotReturnQuotaDataOfOtherAccount(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot andreQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE()));
        quotaProbe.setMaxMessageCount(andreQuotaRoot, QuotaCountLimit.count((long)100L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/get\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"ids\": null\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [[\n         |    \"Quota/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"state\": \"1a9d5db2-2c73-3993-bf0b-42f64b396873\",\n         |      \"list\": [],\n         |      \"notFound\": []\n         |    },\n         |    \"c1\"]]\n         |}")));
    }

    public static /* synthetic */ void quotaGetShouldReturnNotFoundWhenDoesNotPermission$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.quotaGetShouldReturnNotFoundWhenDoesNotPermission(server);
    }

    @Test
    default public void quotaGetShouldReturnNotFoundWhenDoesNotPermission(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot andreQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.ANDRE()));
        quotaProbe.setMaxMessageCount(andreQuotaRoot, QuotaCountLimit.count((long)100L));
        String quotaId = QuotaIdFactory$.MODULE$.from(andreQuotaRoot, (ResourceType)CountResourceType$.MODULE$);
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/get\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"ids\": [\"" + quotaId + "\"]\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [[\n         |    \"Quota/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"state\": \"1a9d5db2-2c73-3993-bf0b-42f64b396873\",\n         |      \"list\": [],\n         |      \"notFound\": [ \"" + new Refined((Object)quotaId) + "\" ]\n         |    },\n         |    \"c1\"]]\n         |}")));
    }

    public static /* synthetic */ void quotaGetShouldReturnIdWhenNoPropertiesRequested$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.quotaGetShouldReturnIdWhenNoPropertiesRequested(server);
    }

    @Test
    default public void quotaGetShouldReturnIdWhenNoPropertiesRequested(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot quotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(quotaRoot, QuotaCountLimit.count((long)100L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/get\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"ids\": null,\n           |      \"properties\": []\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [[\n         |    \"Quota/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"state\": \"84c40a2e-76a1-3f84-a1e8-862104c7a697\",\n         |      \"list\": [\n         |        {\n         |          \"id\": \"08417be420b6dd6fa77d48fb2438e0d19108cd29424844bb109b52d356fab528\"\n         |        }\n         |      ],\n         |      \"notFound\": []\n         |    },\n         |    \"c1\"]]\n         |}")));
    }

    public static /* synthetic */ void quotaGetShouldReturnOnlyRequestedProperties$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.quotaGetShouldReturnOnlyRequestedProperties(server);
    }

    @Test
    default public void quotaGetShouldReturnOnlyRequestedProperties(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot quotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(quotaRoot, QuotaCountLimit.count((long)100L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/get\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"ids\": null,\n           |      \"properties\": [\"name\",\"used\",\"hardLimit\"]\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [[\n         |    \"Quota/get\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"state\": \"84c40a2e-76a1-3f84-a1e8-862104c7a697\",\n         |      \"list\": [\n         |        {\n         |          \"id\": \"08417be420b6dd6fa77d48fb2438e0d19108cd29424844bb109b52d356fab528\",\n         |          \"used\": 0,\n         |          \"name\": \"#private&bob@domain.tld@domain.tld:account:count:Mail\",\n         |          \"hardLimit\": 100\n         |        }\n         |      ],\n         |      \"notFound\": []\n         |    },\n         |    \"c1\"]]\n         |}")));
    }

    public static /* synthetic */ void quotaGetShouldFailWhenInvalidProperties$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.quotaGetShouldFailWhenInvalidProperties(server);
    }

    @Test
    default public void quotaGetShouldFailWhenInvalidProperties(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot quotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(quotaRoot, QuotaCountLimit.count((long)100L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/get\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"ids\": null,\n           |      \"properties\": [\"invalid\"]\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"error\",\n         |            {\n         |                \"type\": \"invalidArguments\",\n         |                \"description\": \"The following properties [invalid] do not exist.\"\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void quotaGetShouldFailWhenInvalidIds$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.quotaGetShouldFailWhenInvalidIds(server);
    }

    @Test
    default public void quotaGetShouldFailWhenInvalidIds(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot quotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(quotaRoot, QuotaCountLimit.count((long)100L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/get\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"ids\": [\"#==id\"]\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"error\",\n         |            {\n         |                \"type\": \"invalidArguments\",\n         |                \"description\": \"${json-unit.any-string}\"\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}")));
    }

    public static /* synthetic */ void quotaGetShouldReturnOnlyUserQuota$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.quotaGetShouldReturnOnlyUserQuota(server);
    }

    @Test
    default public void quotaGetShouldReturnOnlyUserQuota(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        quotaProbe.setMaxStorage(bobQuotaRoot, QuotaSizeLimit.size((long)101L));
        quotaProbe.setGlobalMaxMessageCount(QuotaCountLimit.count((long)90L));
        quotaProbe.setGlobalMaxStorage(QuotaSizeLimit.size((long)99L));
        quotaProbe.setDomainMaxMessage(Fixture$.MODULE$.DOMAIN(), QuotaCountLimit.count((long)80L));
        quotaProbe.setDomainMaxStorage(Fixture$.MODULE$.DOMAIN(), QuotaSizeLimit.size((long)88L));
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).appendMessage(Fixture$.MODULE$.BOB().asString(), MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()), MessageManager.AppendCommand.from((Message)Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8).build())).getMessageId().serialize();
        this.org$apache$james$jmap$rfc8621$contract$QuotaGetMethodContract$$awaitAtMostTenSeconds().untilAsserted(() -> {
            String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |  \"using\": [\n             |    \"urn:ietf:params:jmap:core\",\n             |    \"urn:ietf:params:jmap:quota\"],\n             |  \"methodCalls\": [[\n             |    \"Quota/get\",\n             |    {\n             |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |      \"ids\": null\n             |    },\n             |    \"c1\"]]\n             |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
            JsonAssertions.assertThatJson((Object)response).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n             |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n             |    \"methodResponses\": [\n             |        [\n             |            \"Quota/get\",\n             |            {\n             |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n             |                \"notFound\": [],\n             |                \"state\": \"7d53031b-2819-3584-9e9d-e10ac1067906\",\n             |                \"list\": [\n             |                    {\n             |                        \"used\": 1,\n             |                        \"name\": \"#private&bob@domain.tld@domain.tld:account:count:Mail\",\n             |                        \"id\": \"08417be420b6dd6fa77d48fb2438e0d19108cd29424844bb109b52d356fab528\",\n             |                        \"types\": [\n             |                            \"Mail\"\n             |                        ],\n             |                        \"hardLimit\": 100,\n             |                        \"warnLimit\": 90,\n             |                        \"resourceType\": \"count\",\n             |                        \"scope\": \"account\"\n             |                    },\n             |                    {\n             |                        \"used\": 85,\n             |                        \"name\": \"#private&bob@domain.tld@domain.tld:account:octets:Mail\",\n             |                        \"id\": \"eab6ce8ac5d9730a959e614854410cf39df98ff3760a623b8e540f36f5184947\",\n             |                        \"types\": [\n             |                            \"Mail\"\n             |                        ],\n             |                        \"hardLimit\": 101,\n             |                        \"warnLimit\": 90,\n             |                        \"resourceType\": \"octets\",\n             |                        \"scope\": \"account\"\n             |                    }\n             |                ]\n             |            },\n             |            \"c1\"\n             |        ]\n             |    ]\n             |}\n             |")));
        });
    }

    public static /* synthetic */ void quotaGetShouldNotReturnQuotaRootOfDelegatedMailboxWhenNotExtension$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.quotaGetShouldNotReturnQuotaRootOfDelegatedMailboxWhenNotExtension(server);
    }

    @Test
    default public void quotaGetShouldNotReturnQuotaRootOfDelegatedMailboxWhenNotExtension(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        MailboxPath andreMailbox = MailboxPath.forUser((Username)Fixture$.MODULE$.ANDRE(), (String)"mailbox");
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(andreMailbox);
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(andreMailbox, Fixture$.MODULE$.BOB().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Read}));
        quotaProbe.setMaxMessageCount(quotaProbe.getQuotaRoot(andreMailbox), QuotaCountLimit.count((long)88L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/get\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"ids\": null\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/get\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"notFound\": [],\n         |                \"state\": \"84c40a2e-76a1-3f84-a1e8-862104c7a697\",\n         |                \"list\": [\n         |                    {\n         |                        \"used\": 0,\n         |                        \"name\": \"#private&bob@domain.tld@domain.tld:account:count:Mail\",\n         |                        \"id\": \"08417be420b6dd6fa77d48fb2438e0d19108cd29424844bb109b52d356fab528\",\n         |                        \"types\": [\n         |                            \"Mail\"\n         |                        ],\n         |                        \"hardLimit\": 100,\n         |                        \"warnLimit\": 90,\n         |                        \"resourceType\": \"count\",\n         |                        \"scope\": \"account\"\n         |                    }\n         |                ]\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}\n         |")));
    }

    public static /* synthetic */ void quotaGetShouldReturnQuotaRootOfDelegatedMailboxWhenExtension$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.quotaGetShouldReturnQuotaRootOfDelegatedMailboxWhenExtension(server);
    }

    @Test
    default public void quotaGetShouldReturnQuotaRootOfDelegatedMailboxWhenExtension(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        MailboxPath andreMailbox = MailboxPath.forUser((Username)Fixture$.MODULE$.ANDRE(), (String)"mailbox");
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(andreMailbox);
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(andreMailbox, Fixture$.MODULE$.BOB().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Read}));
        quotaProbe.setMaxMessageCount(quotaProbe.getQuotaRoot(andreMailbox), QuotaCountLimit.count((long)88L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\",\n           |    \"urn:apache:james:params:jmap:mail:shares\" ],\n           |  \"methodCalls\": [[\n           |    \"Quota/get\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"ids\": null\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/get\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"notFound\": [],\n         |                \"state\": \"5dc809dd-d059-3fab-bc7e-c0f1fcacf2f2\",\n         |                \"list\": [\n         |                    {\n         |                        \"used\": 0,\n         |                        \"name\": \"#private&bob@domain.tld@domain.tld:account:count:Mail\",\n         |                        \"id\": \"08417be420b6dd6fa77d48fb2438e0d19108cd29424844bb109b52d356fab528\",\n         |                        \"types\": [\n         |                            \"Mail\"\n         |                        ],\n         |                        \"hardLimit\": 100,\n         |                        \"warnLimit\": 90,\n         |                        \"resourceType\": \"count\",\n         |                        \"scope\": \"account\"\n         |                    },\n         |                    {\n         |                        \"used\": 0,\n         |                        \"name\": \"#private&andre@domain.tld@domain.tld:account:count:Mail\",\n         |                        \"warnLimit\": 79,\n         |                        \"id\": \"04cbe4578878e02a74e47ae6be66c88cc8aafd3a5fc698457d712ee5f9a5b4ca\",\n         |                        \"types\": [\n         |                            \"Mail\"\n         |                        ],\n         |                        \"hardLimit\": 88,\n         |                        \"resourceType\": \"count\",\n         |                        \"scope\": \"account\"\n         |                    }\n         |                ]\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}\n         |")));
    }

    public static /* synthetic */ void quotaGetShouldReturnQuotaRootOfDelegatedMailboxWhenNotHasReadRight$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.quotaGetShouldReturnQuotaRootOfDelegatedMailboxWhenNotHasReadRight(server);
    }

    @Test
    default public void quotaGetShouldReturnQuotaRootOfDelegatedMailboxWhenNotHasReadRight(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        MailboxPath andreMailbox = MailboxPath.forUser((Username)Fixture$.MODULE$.ANDRE(), (String)"mailbox");
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(andreMailbox);
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(andreMailbox, Fixture$.MODULE$.BOB().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup}));
        quotaProbe.setMaxMessageCount(quotaProbe.getQuotaRoot(andreMailbox), QuotaCountLimit.count((long)88L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\",\n           |    \"urn:apache:james:params:jmap:mail:shares\" ],\n           |  \"methodCalls\": [[\n           |    \"Quota/get\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"ids\": null\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/get\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"notFound\": [],\n         |                \"state\": \"84c40a2e-76a1-3f84-a1e8-862104c7a697\",\n         |                \"list\": [\n         |                    {\n         |                        \"used\": 0,\n         |                        \"name\": \"#private&bob@domain.tld@domain.tld:account:count:Mail\",\n         |                        \"id\": \"08417be420b6dd6fa77d48fb2438e0d19108cd29424844bb109b52d356fab528\",\n         |                        \"types\": [\n         |                            \"Mail\"\n         |                        ],\n         |                        \"hardLimit\": 100,\n         |                        \"warnLimit\": 90,\n         |                        \"resourceType\": \"count\",\n         |                        \"scope\": \"account\"\n         |                    }\n         |                ]\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}\n         |")));
    }

    public static /* synthetic */ void quotaGetShouldReturnQuotaRootOfDelegatedMailboxWhenProvideCorrectId$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.quotaGetShouldReturnQuotaRootOfDelegatedMailboxWhenProvideCorrectId(server);
    }

    @Test
    default public void quotaGetShouldReturnQuotaRootOfDelegatedMailboxWhenProvideCorrectId(GuiceJamesServer server) {
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        MailboxPath andreMailbox = MailboxPath.forUser((Username)Fixture$.MODULE$.ANDRE(), (String)"mailbox");
        MailboxId mailboxId = ((MailboxProbeImpl)server.getProbe(MailboxProbeImpl.class)).createMailbox(andreMailbox);
        ((ACLProbeImpl)server.getProbe(ACLProbeImpl.class)).replaceRights(andreMailbox, Fixture$.MODULE$.BOB().asString(), new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Read}));
        quotaProbe.setMaxMessageCount(quotaProbe.getQuotaRoot(andreMailbox), QuotaCountLimit.count((long)88L));
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\",\n           |    \"urn:apache:james:params:jmap:mail:shares\" ],\n           |  \"methodCalls\": [[\n           |    \"Quota/get\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"ids\": [\"04cbe4578878e02a74e47ae6be66c88cc8aafd3a5fc698457d712ee5f9a5b4ca\"]\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/get\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"notFound\": [],\n         |                \"state\": \"5dc809dd-d059-3fab-bc7e-c0f1fcacf2f2\",\n         |                \"list\": [\n         |                    {\n         |                        \"used\": 0,\n         |                        \"name\": \"#private&andre@domain.tld@domain.tld:account:count:Mail\",\n         |                        \"warnLimit\": 79,\n         |                        \"id\": \"04cbe4578878e02a74e47ae6be66c88cc8aafd3a5fc698457d712ee5f9a5b4ca\",\n         |                        \"types\": [\n         |                            \"Mail\"\n         |                        ],\n         |                        \"hardLimit\": 88,\n         |                        \"resourceType\": \"count\",\n         |                        \"scope\": \"account\"\n         |                    }\n         |                ]\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}\n         |")));
    }

    public static /* synthetic */ void shouldSupportQuotaGetDraftCompatibilityWhenEnabled$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.shouldSupportQuotaGetDraftCompatibilityWhenEnabled(server);
    }

    @Test
    default public void shouldSupportQuotaGetDraftCompatibilityWhenEnabled(GuiceJamesServer server) {
        System.setProperty("james.jmap.quota.draft.compatibility", "true");
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        quotaProbe.setMaxStorage(bobQuotaRoot, QuotaSizeLimit.unlimited());
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/get\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"ids\": null\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/get\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"notFound\": [],\n         |                \"state\": \"84c40a2e-76a1-3f84-a1e8-862104c7a697\",\n         |                \"list\": [\n         |                    {\n         |                        \"used\": 0,\n         |                        \"name\": \"#private&bob@domain.tld@domain.tld:account:count:Mail\",\n         |                        \"id\": \"08417be420b6dd6fa77d48fb2438e0d19108cd29424844bb109b52d356fab528\",\n         |                        \"types\": [\"Mail\"],\n         |                        \"dataTypes\": [\"Mail\"],\n         |                        \"hardLimit\": 100,\n         |                        \"limit\": 100,\n         |                        \"warnLimit\": 90,\n         |                        \"resourceType\": \"count\",\n         |                        \"scope\": \"account\"\n         |                    }\n         |                ]\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}\n         |")));
    }

    public static /* synthetic */ void quotaGetDraftCompatibilityShouldStillSupportPropertiesFiltering$(QuotaGetMethodContract $this, GuiceJamesServer server) {
        $this.quotaGetDraftCompatibilityShouldStillSupportPropertiesFiltering(server);
    }

    @Test
    default public void quotaGetDraftCompatibilityShouldStillSupportPropertiesFiltering(GuiceJamesServer server) {
        System.setProperty("james.jmap.quota.draft.compatibility", "true");
        QuotaProbesImpl quotaProbe = (QuotaProbesImpl)server.getProbe(QuotaProbesImpl.class);
        QuotaRoot bobQuotaRoot = quotaProbe.getQuotaRoot(MailboxPath.inbox((Username)Fixture$.MODULE$.BOB()));
        quotaProbe.setMaxMessageCount(bobQuotaRoot, QuotaCountLimit.count((long)100L));
        quotaProbe.setMaxStorage(bobQuotaRoot, QuotaSizeLimit.unlimited());
        String response = ((Validatable)RestAssured.given().body(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |  \"using\": [\n           |    \"urn:ietf:params:jmap:core\",\n           |    \"urn:ietf:params:jmap:quota\"],\n           |  \"methodCalls\": [[\n           |    \"Quota/get\",\n           |    {\n           |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n           |      \"ids\": null,\n           |      \"properties\": [\"limit\", \"dataTypes\"]\n           |    },\n           |    \"c1\"]]\n           |}"))).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).withOptions(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |    \"methodResponses\": [\n         |        [\n         |            \"Quota/get\",\n         |            {\n         |                \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |                \"notFound\": [],\n         |                \"state\": \"84c40a2e-76a1-3f84-a1e8-862104c7a697\",\n         |                \"list\": [\n         |                    {\n         |                        \"id\": \"08417be420b6dd6fa77d48fb2438e0d19108cd29424844bb109b52d356fab528\",\n         |                        \"dataTypes\": [\"Mail\"],\n         |                        \"limit\": 100\n         |                    }\n         |                ]\n         |            },\n         |            \"c1\"\n         |        ]\n         |    ]\n         |}\n         |")));
    }

    public static void $init$(QuotaGetMethodContract $this) {
    }
}

