/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005q2qAB\u0004\u0011\u0002\u0007\u0005A\u0003C\u0003\u001c\u0001\u0011\u0005A\u0004C\u0003!\u0001\u0011\u0005\u0011\u0005C\u00034\u0001\u0011\u0005A\u0004C\u00039\u0001\u0011\u0005A\u0004C\u0003;\u0001\u0011\u0005ADA\u000eNC&d'm\u001c=Rk\u0016\u0014\u0018p\u00115b]\u001e,7oQ8oiJ\f7\r\u001e\u0006\u0003\u0011%\t\u0001bY8oiJ\f7\r\u001e\u0006\u0003\u0015-\tqA\u001d4dqY\u0012\u0014G\u0003\u0002\r\u001b\u0005!!.\\1q\u0015\tqq\"A\u0003kC6,7O\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7\u0001A\n\u0003\u0001U\u0001\"AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011a!\u00118z%\u00164\u0017A\u0002\u0013j]&$H\u0005F\u0001\u001e!\t1b$\u0003\u0002 /\t!QK\\5u\u0003\u0015\u0019X\r^+q)\ti\"\u0005C\u0003$\u0005\u0001\u0007A%\u0001\u0004tKJ4XM\u001d\t\u0003K\u0019j\u0011!D\u0005\u0003O5\u0011\u0001cR;jG\u0016T\u0015-\\3t'\u0016\u0014h/\u001a:)\u0005\tI\u0003C\u0001\u00162\u001b\u0005Y#B\u0001\u0017.\u0003\r\t\u0007/\u001b\u0006\u0003]=\nqA[;qSR,'O\u0003\u00021#\u0005)!.\u001e8ji&\u0011!g\u000b\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017AI:i_VdGMU3ukJt7)\u00198o_R\u001c\u0015\r\\2vY\u0006$Xm\u00115b]\u001e,7\u000f\u000b\u0002\u0004kA\u0011!FN\u0005\u0003o-\u0012A\u0001V3ti\u0006qrO]8oO\u0006\u001b7m\\;oi&#7\u000b[8vY\u0012\u0014UMU3kK\u000e$X\r\u001a\u0015\u0003\tU\n\u0001#\\5tg\u000e\u000b\u0007/\u00192jY&$\u0018.Z:)\u0005\u0015)\u0004")
public interface MailboxQueryChangesContract {
    public static /* synthetic */ void setUp$(MailboxQueryChangesContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addDomain("domain-alias.tld").addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD()).addUser(Fixture$.MODULE$.ANDRE().asString(), Fixture$.MODULE$.ANDRE_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void shouldReturnCannotCalculateChanges$(MailboxQueryChangesContract $this) {
        $this.shouldReturnCannotCalculateChanges();
    }

    @Test
    default public void shouldReturnCannotCalculateChanges() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/queryChanges\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceQueryState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a941\",\n         |      \"calculateTotal\": false\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"error\",\n           |            {\n           |                \"type\": \"cannotCalculateChanges\",\n           |                \"description\": \"Naive implementation for Mailbox/queryChanges\"\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void wrongAccountIdShouldBeRejected$(MailboxQueryChangesContract $this) {
        $this.wrongAccountIdShouldBeRejected();
    }

    @Test
    default public void wrongAccountIdShouldBeRejected() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\", \"urn:ietf:params:jmap:mail\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/queryChanges\",\n         |    {\n         |      \"accountId\": \"1e8584548eca20f26faf6becc1704a0f352839f12c208a47fbd486d60f491f7c\",\n         |      \"sinceQueryState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a941\",\n         |      \"calculateTotal\": false\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"error\",\n           |            {\n           |                \"type\": \"accountNotFound\"\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static /* synthetic */ void missCapabilities$(MailboxQueryChangesContract $this) {
        $this.missCapabilities();
    }

    @Test
    default public void missCapabilities() {
        String request = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"using\": [\"urn:ietf:params:jmap:core\"],\n         |  \"methodCalls\": [[\n         |    \"Mailbox/queryChanges\",\n         |    {\n         |      \"accountId\": \"29883977c13473ae7cb7678ef767cbfbaffc8a44a6e463d971d23a65c1dc4af6\",\n         |      \"sinceQueryState\": \"2c9f1b12-b35a-43e6-9af2-0106fb53a941\",\n         |      \"calculateTotal\": false\n         |    },\n         |    \"c1\"]]\n         |}"));
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(request).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n           |    \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n           |    \"methodResponses\": [\n           |        [\n           |            \"error\",\n           |            {\n           |                \"type\": \"unknownMethod\",\n           |                \"description\": \"Missing capability(ies): urn:ietf:params:jmap:mail\"\n           |            },\n           |            \"c1\"\n           |        ]\n           |    ]\n           |}")));
    }

    public static void $init$(MailboxQueryChangesContract $this) {
    }
}

