/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.rfc8621.contract;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.restassured.RestAssured;
import io.restassured.authentication.AuthenticationScheme;
import io.restassured.http.ContentType;
import io.restassured.response.Validatable;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.GuiceJamesServer;
import org.apache.james.jmap.core.ResponseObject$;
import org.apache.james.jmap.http.UserCredential;
import org.apache.james.jmap.rfc8621.contract.EchoMethodContract$;
import org.apache.james.jmap.rfc8621.contract.Fixture$;
import org.apache.james.probe.DataProbe;
import org.apache.james.utils.DataProbeImpl;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0019<Qa\u0004\t\t\u0002u1Qa\b\t\t\u0002\u0001BQaJ\u0001\u0005\u0002!Bq!K\u0001C\u0002\u0013%!\u0006\u0003\u00047\u0003\u0001\u0006Ia\u000b\u0005\bo\u0005\u0011\r\u0011\"\u0003+\u0011\u0019A\u0014\u0001)A\u0005W\u00199q\u0004\u0005I\u0001\u0004\u0003I\u0004\"\u0002\u001e\b\t\u0003Y\u0004\"B \b\t\u0003\u0001\u0005\"\u0002*\b\t\u0003Y\u0004\"\u00020\b\t\u0003Y\u0004\"\u00021\b\t\u0003Y\u0004\"\u00022\b\t\u0003Y\u0004\"\u00023\b\t\u0003Y\u0014AE#dQ>lU\r\u001e5pI\u000e{g\u000e\u001e:bGRT!!\u0005\n\u0002\u0011\r|g\u000e\u001e:bGRT!a\u0005\u000b\u0002\u000fI47\r\u000f\u001c3c)\u0011QCF\u0001\u0005U6\f\u0007O\u0003\u0002\u00181\u0005)!.Y7fg*\u0011\u0011DG\u0001\u0007CB\f7\r[3\u000b\u0003m\t1a\u001c:h\u0007\u0001\u0001\"AH\u0001\u000e\u0003A\u0011!#R2i_6+G\u000f[8e\u0007>tGO]1diN\u0011\u0011!\t\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0012A\n*F#V+5\u000bV0P\u0005*+5\tV0X\u0013RCu,\u0016(T+B\u0003vJ\u0015+F\t~kU\t\u0016%P\tV\t1\u0006\u0005\u0002-g9\u0011Q&\r\t\u0003]\rj\u0011a\f\u0006\u0003aq\ta\u0001\u0010:p_Rt\u0014B\u0001\u001a$\u0003\u0019\u0001&/\u001a3fM&\u0011A'\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I\u001a\u0013a\n*F#V+5\u000bV0P\u0005*+5\tV0X\u0013RCu,\u0016(T+B\u0003vJ\u0015+F\t~kU\t\u0016%P\t\u0002\nqEU#T!>s5+R0P\u0005*+5\tV0X\u0013RCu,\u0016(T+B\u0003vJ\u0015+F\t~kU\t\u0016%P\t\u0006A#+R*Q\u001f:\u001bViX(C\u0015\u0016\u001bEkX,J)\"{VKT*V!B{%\u000bV#E?6+E\u000bS(EAM\u0011q!I\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003q\u0002\"AI\u001f\n\u0005y\u001a#\u0001B+oSR\fQa]3u+B$\"\u0001P!\t\u000b\tK\u0001\u0019A\"\u0002\rM,'O^3s!\t!U)D\u0001\u0017\u0013\t1eC\u0001\tHk&\u001cWMS1nKN\u001cVM\u001d<fe\"\u0012\u0011\u0002\u0013\t\u0003\u0013Bk\u0011A\u0013\u0006\u0003\u00172\u000b1!\u00199j\u0015\tie*A\u0004kkBLG/\u001a:\u000b\u0005=S\u0012!\u00026v]&$\u0018BA)K\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001>K\u000eDw.T3uQ>$7\u000b[8vY\u0012\u0014Vm\u001d9p]\u0012|5jV5uQJ35\t\u000f\u001c3cY+'o]5p]\u0006sGmU;qa>\u0014H/\u001a3NKRDw\u000e\u001a\u0015\u0003\u0015Q\u0003\"!S+\n\u0005YS%\u0001\u0002+fgRDCA\u0003-\\9B\u0011\u0011*W\u0005\u00035*\u00131\u0001V1h\u0003\u00151\u0018\r\\;fC\u0005i\u0016\u0001\u0004\"bg&\u001cg)Z1ukJ,\u0017AG1qSNCw.\u001e7e%\u0016TWm\u0019;CS\u001e\u0014V-];fgR\u001c\bFA\u0006U\u0003m\t\u0007/[*i_VdGMU3kK\u000e$Hk\\8NC:L8)\u00197mg\"\u0012A\u0002V\u0001>K\u000eDw.T3uQ>$7\u000b[8vY\u0012\u0014Vm\u001d9p]\u0012<\u0016\u000e\u001e5S\r\u000eCdGM\u0019WKJ\u001c\u0018n\u001c8B]\u0012,fn];qa>\u0014H/\u001a3NKRDw\u000e\u001a\u0015\u0003\u001bQ\u000bA(Z2i_6+G\u000f[8e'\"|W\u000f\u001c3SKR,(O\\+oW:|wO\\'fi\"|Gm\u00165f]6K7o]5oO\u000e{'/Z\"ba\u0006\u0014\u0017\u000e\\5us\"\u0012a\u0002\u0016")
public interface EchoMethodContract {
    public static /* synthetic */ void setUp$(EchoMethodContract $this, GuiceJamesServer server) {
        $this.setUp(server);
    }

    @BeforeEach
    default public void setUp(GuiceJamesServer server) {
        ((DataProbe)server.getProbe(DataProbeImpl.class)).fluent().addDomain(Fixture$.MODULE$.DOMAIN().asString()).addUser(Fixture$.MODULE$.BOB().asString(), Fixture$.MODULE$.BOB_PASSWORD());
        RestAssured.requestSpecification = Fixture$.MODULE$.baseRequestSpecBuilder(server).setAuth((AuthenticationScheme)Fixture$.MODULE$.authScheme(new UserCredential(Fixture$.MODULE$.BOB(), Fixture$.MODULE$.BOB_PASSWORD()))).build();
    }

    public static /* synthetic */ void echoMethodShouldRespondOKWithRFC8621VersionAndSupportedMethod$(EchoMethodContract $this) {
        $this.echoMethodShouldRespondOKWithRFC8621VersionAndSupportedMethod();
    }

    @Test
    @Tag(value="BasicFeature")
    default public void echoMethodShouldRespondOKWithRFC8621VersionAndSupportedMethod() {
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(Fixture$.MODULE$.ECHO_REQUEST_OBJECT()).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)Fixture$.MODULE$.ECHO_RESPONSE_OBJECT());
    }

    public static /* synthetic */ void apiShouldRejectBigRequests$(EchoMethodContract $this) {
        $this.apiShouldRejectBigRequests();
    }

    @Test
    default public void apiShouldRejectBigRequests() {
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(Fixture$.MODULE$.BIG_ECHO_REQUEST_OBJECT()).when().post()).then().statusCode(400).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"type\": \"urn:ietf:params:jmap:error:limit\",\n        |    \"status\": 400,\n        |    \"limit\": \"maxSizeRequest\",\n        |    \"detail\": \"Request size is exceeded. Was 10000192 but maximum allowed is 10000000\"\n        |}")));
    }

    public static /* synthetic */ void apiShouldRejectTooManyCalls$(EchoMethodContract $this) {
        $this.apiShouldRejectTooManyCalls();
    }

    @Test
    default public void apiShouldRejectTooManyCalls() {
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(Fixture$.MODULE$.TOO_MANY_CALLS_ECHO_REQUEST_OBJECT()).when().post()).then().statusCode(400).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        |    \"type\": \"urn:ietf:params:jmap:error:limit\",\n        |    \"status\": 400,\n        |    \"limit\": \"maxCallsInRequest\",\n        |    \"detail\": \"Request call count limit is exceeded. Was 17 but maximum allowed is 16\"\n        |}")));
    }

    public static /* synthetic */ void echoMethodShouldRespondWithRFC8621VersionAndUnsupportedMethod$(EchoMethodContract $this) {
        $this.echoMethodShouldRespondWithRFC8621VersionAndUnsupportedMethod();
    }

    @Test
    default public void echoMethodShouldRespondWithRFC8621VersionAndUnsupportedMethod() {
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(EchoMethodContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$EchoMethodContract$$REQUEST_OBJECT_WITH_UNSUPPORTED_METHOD()).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)EchoMethodContract$.MODULE$.org$apache$james$jmap$rfc8621$contract$EchoMethodContract$$RESPONSE_OBJECT_WITH_UNSUPPORTED_METHOD());
    }

    public static /* synthetic */ void echoMethodShouldReturnUnknownMethodWhenMissingCoreCapability$(EchoMethodContract $this) {
        $this.echoMethodShouldReturnUnknownMethodWhenMissingCoreCapability();
    }

    @Test
    default public void echoMethodShouldReturnUnknownMethodWhenMissingCoreCapability() {
        String response = ((Validatable)RestAssured.given().header(HttpHeaderNames.ACCEPT.toString(), (Object)Fixture$.MODULE$.ACCEPT_RFC8621_VERSION_HEADER(), new Object[0]).body(Fixture$.MODULE$.ECHO_REQUEST_OBJECT_WITHOUT_CORE_CAPABILITY()).when().post()).then().statusCode(200).contentType(ContentType.JSON).extract().body().asString();
        JsonAssertions.assertThatJson((Object)response).isEqualTo((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n         |  \"sessionState\": \"" + ResponseObject$.MODULE$.SESSION_STATE().value() + "\",\n         |  \"methodResponses\": [[\n         |    \"error\",\n         |    {\n         |      \"type\": \"unknownMethod\",\n         |      \"description\": \"Missing capability(ies): urn:ietf:params:jmap:core\"\n         |    },\n         |    \"c1\"]]\n         |}")));
    }

    public static void $init$(EchoMethodContract $this) {
    }
}

