/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;

public class MimeMessageUtil {
    public static String asString(MimeMessage mimeMessage) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        mimeMessage.writeTo((OutputStream)byteArrayOutputStream);
        return new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
    }

    public static MimeMessage defaultMimeMessage() {
        return new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
    }

    public static MimeMessage mimeMessageFromStream(InputStream inputStream) throws MessagingException {
        return new MimeMessage(Session.getDefaultInstance((Properties)new Properties()), inputStream);
    }

    public static MimeMessage mimeMessageFromBytes(byte[] bytes) throws MessagingException {
        return MimeMessageUtil.mimeMessageFromStream(new ByteArrayInputStream(bytes));
    }

    public static MimeMessage mimeMessageFromString(String string) throws MessagingException {
        return MimeMessageUtil.mimeMessageFromBytes(string.getBytes(StandardCharsets.UTF_8));
    }
}

