/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class CompletableFutureUtil {
    public static <T> CompletableFuture<Optional<T>> unwrap(CompletableFuture<Optional<CompletableFuture<T>>> base) {
        return base.thenCompose(optional -> optional.map(future -> future.thenApply(Optional::of)).orElse(CompletableFuture.completedFuture(Optional.empty())));
    }

    public static <T> CompletableFuture<Stream<T>> allOf(Stream<CompletableFuture<T>> futureStream) {
        CompletableFuture[] arrayOfFutures = (CompletableFuture[])futureStream.toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(arrayOfFutures).thenApply(any -> Arrays.stream(arrayOfFutures).map(CompletableFuture::join));
    }

    public static <R, T> CompletableFuture<Stream<R>> chainAll(Stream<T> futureStream, Function<T, CompletableFuture<R>> transformationToChain) {
        ImmutableList elements = (ImmutableList)futureStream.collect(ImmutableList.toImmutableList());
        ArrayList results = new ArrayList(elements.size());
        CompletableFuture<Object> futureEmptyStream = CompletableFuture.completedFuture(null);
        BiFunction<CompletableFuture, Supplier, CompletableFuture> accumulator = (future, supplier) -> future.thenCompose(arg_0 -> CompletableFutureUtil.lambda$null$4((Supplier)supplier, results, arg_0));
        BinaryOperator combiner = (f1, f2) -> f1.thenCompose(any -> f2);
        return elements.stream().map(t -> () -> (CompletableFuture)transformationToChain.apply(t)).reduce(futureEmptyStream, accumulator, combiner).thenApply(any -> results.stream());
    }

    public static <T, U> CompletableFuture<Stream<U>> map(CompletableFuture<Stream<T>> futurStream, Function<T, U> action) {
        return futurStream.thenApply(stream -> stream.map(action));
    }

    public static <T> CompletableFuture<Optional<T>> reduce(BinaryOperator<T> binaryOperator, CompletableFuture<Stream<T>> futureStream) {
        return futureStream.thenApply(stream -> stream.reduce(binaryOperator));
    }

    public static <T> CompletableFuture<T> reduce(BinaryOperator<T> binaryOperator, CompletableFuture<Stream<T>> futureStream, T emptyAccumulator) {
        return futureStream.thenApply(stream -> stream.reduce(binaryOperator).orElse(emptyAccumulator));
    }

    public static <T> Function<Boolean, CompletableFuture<Boolean>> composeIfTrue(Supplier<CompletableFuture<T>> composeOperation) {
        return b -> {
            if (b.booleanValue()) {
                return ((CompletableFuture)composeOperation.get()).thenApply(any -> b);
            }
            return CompletableFuture.completedFuture(b);
        };
    }

    public static <T> CompletableFuture<Stream<T>> sorted(CompletableFuture<Stream<T>> futureStream, Comparator<T> comparator) {
        return futureStream.thenApply(stream -> stream.sorted(comparator));
    }

    public static <T> CompletableFuture<T> exceptionallyFuture(Throwable throwable) {
        CompletableFuture failedFuture = new CompletableFuture();
        failedFuture.completeExceptionally(throwable);
        return failedFuture;
    }

    private static /* synthetic */ CompletionStage lambda$null$4(Supplier supplier, ArrayList results, Object any) {
        return ((CompletableFuture)supplier.get()).thenAccept(results::add);
    }
}

