/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.math3.distribution.EnumeratedDistribution;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.util.Pair;

public class DiscreteDistribution<T> {
    private final EnumeratedDistribution<T> enumeratedDistribution;

    public static <T> DiscreteDistribution<T> create(List<DistributionEntry<T>> distribution) {
        double totalOccurrenceCount = distribution.stream().mapToDouble(DistributionEntry::getAssociatedProbability).sum();
        Preconditions.checkArgument((totalOccurrenceCount > 0.0 ? 1 : 0) != 0, (Object)"You need to have some entries with non-zero occurrence count in your distribution");
        return new DiscreteDistribution<T>(distribution);
    }

    private DiscreteDistribution(List<DistributionEntry<T>> distribution) {
        this.enumeratedDistribution = new EnumeratedDistribution((RandomGenerator)new MersenneTwister(), (List)distribution.stream().map(DistributionEntry::toPair).collect(ImmutableList.toImmutableList()));
    }

    public Stream<T> generateRandomStream() {
        return Stream.iterate(this, i -> i).map(DiscreteDistribution::sample);
    }

    public T sample() {
        return (T)this.enumeratedDistribution.sample();
    }

    public static class DistributionEntry<V> {
        private final V value;
        private final double associatedProbability;

        public DistributionEntry(V value, double associatedProbability) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0);
            Preconditions.checkArgument((associatedProbability >= 0.0 ? 1 : 0) != 0, (Object)"The occurence count needs to be positive");
            this.value = value;
            this.associatedProbability = associatedProbability;
        }

        public V getValue() {
            return this.value;
        }

        public double getAssociatedProbability() {
            return this.associatedProbability;
        }

        public Pair<V, Double> toPair() {
            return new Pair(this.value, (Object)this.associatedProbability);
        }
    }
}

