/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.mailbox;

import java.util.Map;
import org.apache.james.adapter.mailbox.MailboxManagerResolver;
import org.apache.james.adapter.mailbox.MailboxManagerResolverException;
import org.apache.james.mailbox.MailboxManager;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringResolver
implements MailboxManagerResolver,
ApplicationContextAware {
    private ApplicationContext context;

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    public MailboxManager resolveMailboxManager(String mailboxManagerClassName) {
        try {
            return (MailboxManager)this.context.getBean(mailboxManagerClassName, MailboxManager.class);
        }
        catch (BeansException e) {
            throw new MailboxManagerResolverException((Throwable)e);
        }
    }

    public Map<String, MailboxManager> getMailboxManagerBeans() {
        try {
            return this.context.getBeansOfType(MailboxManager.class);
        }
        catch (BeansException e) {
            throw new MailboxManagerResolverException((Throwable)e);
        }
    }
}

